/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PostReformPortugueseCompoundRule
extends AbstractCompoundRule {
    private static final Pattern HYPHEN = Pattern.compile("-");
    private static final Pattern VOWEL = Pattern.compile("(?i).+[aeiou]$");
    private static final Pattern RS = Pattern.compile("(?i)^[rs].+");
    private static volatile CompoundRuleData compoundData;

    public PostReformPortugueseCompoundRule(ResourceBundle messages, Language lang, UserConfig userConfig) throws IOException {
        super(messages, lang, userConfig, "Esta palavra \u00e9 hifenizada.", "Esta palavra \u00e9 composta por justaposi\u00e7\u00e3o.", "Esta palavra pode ser composta por justaposi\u00e7\u00e3o ou hifenizada.", "Este conjunto forma uma palavra composta.");
        super.setCategory(Categories.COMPOUNDING.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.useSubRuleSpecificIds();
    }

    public String getId() {
        return "PT_COMPOUNDS_POST_REFORM";
    }

    public String getDescription() {
        return "Erro na forma\u00e7\u00e3o da palavra composta \"$match\"";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Lista_das_altera\u00e7\u00f5es_previstas_pelo_acordo_ortogr\u00e1fico_de_1990");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundRuleData getCompoundRuleData() {
        CompoundRuleData data = compoundData;
        if (data != null) return data;
        Class<PostReformPortugueseCompoundRule> clazz = PostReformPortugueseCompoundRule.class;
        synchronized (PostReformPortugueseCompoundRule.class) {
            data = compoundData;
            if (data != null) return data;
            compoundData = data = new CompoundRuleData("/pt/post-reform-compounds.txt");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }

    public String mergeCompound(String str, boolean uncapitalizeMidWords) {
        String[] stringParts = HYPHEN.matcher(str).replaceAll(" ").split(" ");
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < stringParts.length; ++k) {
            if (k == 0) {
                sb.append(stringParts[0]);
                continue;
            }
            if (VOWEL.matcher(stringParts[k - 1]).matches() && RS.matcher(stringParts[k]).matches()) {
                stringParts[k] = stringParts[k].charAt(0) + stringParts[k];
            }
            sb.append(uncapitalizeMidWords ? StringUtils.uncapitalize((String)stringParts[k]) : stringParts[k]);
        }
        return sb.toString();
    }
}

