/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class EnglishContractionSpellingRule
extends AbstractSimpleReplaceRule {
    public static final String ENGLISH_CONTRACTION_SPELLING_RULE = "PT_ENGLISH_CONTRACTION_ORTHOGRAPHY";
    private static final Map<String, List<String>> wrongWords = EnglishContractionSpellingRule.loadFromPath((String)"/pt/english_contractions.txt");
    private static final Locale PT_LOCALE = new Locale("pt");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public EnglishContractionSpellingRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"Ele adorava assistir <marker>whats</marker> cooking \u00e0s sextas-feiras."), Example.fixed((String)"Ele adorava assistir <marker>what's</marker> cooking \u00e0s sextas-feiras."));
        super.setCheckLemmas(false);
    }

    public final String getId() {
        return ENGLISH_CONTRACTION_SPELLING_RULE;
    }

    public String getDescription() {
        return "Ortografia de contra\u00e7\u00f5es inglesas";
    }

    public String getShort() {
        return "Erro de ortografia inglesa";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Caso seja uma contra\u00e7\u00e3o da l\u00edngua inglesa, prefira \"" + replacements.get(0) + "\".";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

