/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.Map;
import java.util.regex.Matcher;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RegexRuleFilter;
import org.languagetool.rules.pt.BrazilianToponymMap;

public class BrazilianToponymFilter
extends RegexRuleFilter {
    private static final BrazilianToponymMap map = new BrazilianToponymMap();

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, AnalyzedSentence sentence, Matcher matcher) {
        String toponym = matcher.group(1);
        String underlined = matcher.group(2);
        String state = matcher.group(3);
        String suggestion = "\u2013" + state;
        if (suggestion.equals(underlined)) {
            return null;
        }
        if (!map.isValidToponym(toponym)) {
            return null;
        }
        match.setSuggestedReplacement(suggestion);
        return match;
    }
}

