/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.synthesis.pt.PortugueseSynthesizer;
import org.languagetool.tagging.pt.PortugueseTagger;
import org.languagetool.tools.StringTools;

public class MorfologikPortugueseSpellerRule
extends MorfologikSpellerRule {
    private final Language spellerLanguage;
    private final String dictFilepath;
    private static final String doNotSuggestWordsFilepath = "/pt/do_not_suggest.txt";
    private static final Set<String> doNotSuggestWords = MorfologikPortugueseSpellerRule.getDoNotSuggestWords();
    private static final String abbreviationFilepath = "/pt/abbreviations.txt";
    private static final Set<String> abbreviations = MorfologikPortugueseSpellerRule.getAbbreviations();
    private static final String dialectAlternationsFilepath = "/pt/dialect_alternations.txt";
    private final Map<String, String> dialectAlternationMapping;
    private static final PortugueseTagger tagger = new PortugueseTagger();
    private static final PortugueseSynthesizer synth = PortugueseSynthesizer.INSTANCE;
    private static final String SPELLING_FILE = "pt/spelling.txt";
    private static final String MULTIWORDS_FILE = "pt/multiwords.txt";
    private static final String SPELLING_IGNORE_FILE = "pt/ignore.txt";
    private static final String SPELLING_PROHIBIT_FILE = "pt/prohibit.txt";

    public String getFileName() {
        return this.dictFilepath;
    }

    public static Set<String> getDoNotSuggestWords() {
        return MorfologikPortugueseSpellerRule.getWordSetFromResources(doNotSuggestWordsFilepath);
    }

    public static Set<String> getAbbreviations() {
        return MorfologikPortugueseSpellerRule.getWordSetFromResources(abbreviationFilepath);
    }

    public static Set<String> getWordSetFromResources(String filepath) {
        return new HashSet<String>(JLanguageTool.getDataBroker().getFromResourceDirAsLines(filepath));
    }

    public String getIgnoreFileName() {
        return SPELLING_IGNORE_FILE;
    }

    public String getProhibitFileName() {
        return SPELLING_PROHIBIT_FILE;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_" + this.language.getShortCodeWithCountryAndVariant().replace("-", "_").toUpperCase();
    }

    protected String getIdForDialectIssue() {
        return this.getId() + "_DIALECT";
    }

    @Nullable
    protected String dialectAlternative(String word) throws IOException {
        String lemmaCheckResult = this.dialectAlternationMapping.get(word.toLowerCase());
        if (lemmaCheckResult != null) {
            return lemmaCheckResult;
        }
        List<String> wordAsList = Collections.singletonList(word);
        List<AnalyzedTokenReadings> readings = tagger.tag(wordAsList);
        for (AnalyzedTokenReadings reading : readings) {
            for (AnalyzedToken token : reading.getReadings()) {
                Predicate<String> tagPredicate;
                String candidate;
                String[] forms;
                String lemma = token.getLemma();
                String tag = token.getPOSTag();
                if (tag == null || !this.dialectAlternationMapping.containsKey(lemma) || (forms = synth.synthesizeForPosTags(candidate = this.dialectAlternationMapping.get(lemma), tagPredicate = tagStr -> tagStr.contentEquals(tag))).length <= 0) continue;
                return forms[0];
            }
        }
        return null;
    }

    @Nullable
    private String checkDiaeresis(String word) {
        if (word.indexOf(252) >= 0) {
            return word.replace('\u00fc', 'u');
        }
        return null;
    }

    @Nullable
    private String checkEuropeanStyle1PLPastTense(String word) {
        if (Objects.equals(this.spellerLanguage.getShortCodeWithCountryAndVariant(), "pt-BR") && word.endsWith("\u00e1mos")) {
            return word.replace('\u00e1', 'a');
        }
        return null;
    }

    private boolean isTitlecasedHyphenatedWord(String[] wordParts) {
        for (String part : wordParts) {
            if (!StringTools.isMixedCase((String)part)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private String checkCompoundElements(String[] wordParts) {
        ArrayList suggestedParts = new ArrayList();
        for (String part : wordParts) {
            if (this.speller1.isMisspelled(part)) {
                suggestedParts.add(this.speller1.getSuggestions(part).get(0));
                continue;
            }
            suggestedParts.add(part);
        }
        String newSuggestion = String.join((CharSequence)"-", suggestedParts);
        if (newSuggestion.equals(String.join((CharSequence)"-", wordParts))) {
            return null;
        }
        return newSuggestion;
    }

    private Map<String, String> getDialectAlternationMapping() {
        HashMap<String, String> wordMap = new HashMap<String, String>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(dialectAlternationsFilepath);
        String fullLanguageCode = this.spellerLanguage.getShortCodeWithCountryAndVariant();
        int column = -1;
        switch (fullLanguageCode) {
            case "pt-BR": {
                column = 1;
                break;
            }
            case "pt-PT": {
                column = 0;
            }
        }
        if (column == -1) {
            return Collections.emptyMap();
        }
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parsedLine = line.split("=");
            if (parsedLine.length != 2) {
                throw new RuntimeException("Unexpected format in /pt/dialect_alternations.txt: " + line + " - expected two parts delimited by '='");
            }
            wordMap.put(parsedLine[column].toLowerCase(), parsedLine[column == 1 ? 0 : 1]);
        }
        return wordMap;
    }

    public MorfologikPortugueseSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.spellerLanguage = language.getShortCodeWithCountryAndVariant().equals("pt") ? language.getDefaultLanguageVariant() : language;
        this.dictFilepath = "/pt/spelling/" + this.getDictFilename() + ".dict";
        this.dialectAlternationMapping = this.getDialectAlternationMapping();
    }

    protected List<SuggestedReplacement> filterNoSuggestWords(List<SuggestedReplacement> suggestedReplacements) {
        return suggestedReplacements.stream().filter(suggestedReplacement -> !doNotSuggestWords.contains(suggestedReplacement.getReplacement().toLowerCase())).collect(Collectors.toList());
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> suggestionsList = suggestions.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        return SuggestedReplacement.convert(this.getAdditionalTopSuggestionsString(suggestionsList, word));
    }

    private List<String> getAdditionalTopSuggestionsString(List<String> suggestions, String word) throws IOException {
        if (this.isAbbreviation(word)) {
            return Collections.singletonList(word + ".");
        }
        return Collections.emptyList();
    }

    protected boolean isAbbreviation(String word) {
        return abbreviations.contains(word + ".") || abbreviations.contains(word.toLowerCase() + ".");
    }

    private String getDictFilename() {
        String fullLanguageCode;
        String dictFilename = "pt-BR";
        switch (fullLanguageCode = this.spellerLanguage.getShortCodeWithCountryAndVariant()) {
            case "pt-BR": {
                dictFilename = "pt-BR";
                break;
            }
            case "pt-PT": {
                dictFilename = "pt-PT-90";
                break;
            }
            case "pt-AO": 
            case "pt-MZ": {
                dictFilename = "pt-PT-45";
            }
        }
        return dictFilename;
    }

    public List<String> getAdditionalSpellingFileNames() {
        return Arrays.asList("spelling_global.txt", SPELLING_FILE, MULTIWORDS_FILE);
    }

    private void replaceFormsOfFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, String suggestion, boolean dialectIssue) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        newMatch.setType(oldMatch.getType());
        if (dialectIssue) {
            newMatch.setSpecificRuleId(this.getIdForDialectIssue());
        }
        SuggestedReplacement sugg = new SuggestedReplacement(suggestion);
        sugg.setShortDescription(this.language.getName());
        newMatch.setSuggestedReplacementObjects(Collections.singletonList(sugg));
        ruleMatches.set(0, newMatch);
    }

    public List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        List<Object> ruleMatches = super.getRuleMatches(word, startPos, sentence, ruleMatchesSoFar, idx, tokens);
        if (!ruleMatches.isEmpty()) {
            String dialectAlternative;
            String wordWithoutDiaeresis;
            String wordWithBrazilianStylePastTense;
            if (word.indexOf(45) > 0) {
                String[] wordParts = word.split("-");
                if (this.isTitlecasedHyphenatedWord(wordParts) && !this.speller1.isMisspelled(word.toLowerCase())) {
                    ruleMatches = Collections.emptyList();
                }
                if (!ruleMatches.isEmpty() && ((RuleMatch)ruleMatches.get(0)).getSuggestedReplacements().isEmpty()) {
                    String newSuggestion = this.checkCompoundElements(wordParts);
                    if (newSuggestion == null) {
                        ruleMatches = Collections.emptyList();
                    } else {
                        this.replaceFormsOfFirstMatch(((RuleMatch)ruleMatches.get(0)).getMessage(), sentence, ruleMatches, newSuggestion, false);
                    }
                }
            }
            if ((wordWithBrazilianStylePastTense = this.checkEuropeanStyle1PLPastTense(word)) != null) {
                String message = "No Brasil, o pret\u00e9rito perfeito da primeira pessoa do plural escreve-se sem acento.";
                this.replaceFormsOfFirstMatch(message, sentence, (List<RuleMatch>)ruleMatches, wordWithBrazilianStylePastTense, true);
            }
            if ((wordWithoutDiaeresis = this.checkDiaeresis(word)) != null) {
                String message = "No mais recente acordo ortogr\u00e1fico, n\u00e3o se usa mais o trema no portugu\u00eas.";
                this.replaceFormsOfFirstMatch(message, sentence, ruleMatches, wordWithoutDiaeresis, false);
            }
            if ((dialectAlternative = this.dialectAlternative(word)) != null) {
                String otherVariant = "europeu";
                if (Objects.equals(this.spellerLanguage.getShortCodeWithCountryAndVariant(), "pt-PT")) {
                    otherVariant = "brasileiro";
                }
                String message = "Poss\u00edvel erro de ortografia: esta \u00e9 a grafia utilizada no portugu\u00eas " + otherVariant + ".";
                String suggestion = StringTools.startsWithUppercase((String)word) ? StringTools.uppercaseFirstChar((String)dialectAlternative) : dialectAlternative;
                this.replaceFormsOfFirstMatch(message, sentence, ruleMatches, suggestion, true);
            }
        }
        return ruleMatches;
    }
}

