/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.pt.MorfologikPortugueseSpellerRule;
import org.languagetool.rules.pt.PortugueseAccentuationCheckRule;
import org.languagetool.rules.pt.PortugueseBarbarismsRule;
import org.languagetool.rules.pt.PortugueseClicheRule;
import org.languagetool.rules.pt.PortugueseColourHyphenationRule;
import org.languagetool.rules.pt.PortugueseConfusionProbabilityRule;
import org.languagetool.rules.pt.PortugueseDiacriticsRule;
import org.languagetool.rules.pt.PortugueseFillerWordsRule;
import org.languagetool.rules.pt.PortugueseMultitokenSpeller;
import org.languagetool.rules.pt.PortugueseReadabilityRule;
import org.languagetool.rules.pt.PortugueseRedundancyRule;
import org.languagetool.rules.pt.PortugueseReplaceRule;
import org.languagetool.rules.pt.PortugueseUnitConversionRule;
import org.languagetool.rules.pt.PortugueseWikipediaRule;
import org.languagetool.rules.pt.PortugueseWordCoherencyRule;
import org.languagetool.rules.pt.PortugueseWordRepeatBeginningRule;
import org.languagetool.rules.pt.PortugueseWordRepeatRule;
import org.languagetool.rules.pt.PortugueseWordinessRule;
import org.languagetool.rules.pt.PortugueseWrongWordInContextRule;
import org.languagetool.rules.pt.PostReformPortugueseCompoundRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.multitoken.MultitokenSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.pt.PortugueseSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.pt.PortugueseHybridDisambiguator;
import org.languagetool.tagging.pt.PortugueseTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.pt.PortugueseWordTokenizer;

public class Portuguese
extends Language
implements AutoCloseable {
    private LanguageModel languageModel;
    private static final Map<String, Integer> id2prio = new HashMap<String, Integer>();

    public String getName() {
        return "Portuguese";
    }

    public String getShortCode() {
        return "pt";
    }

    public String[] getCountries() {
        return new String[]{"", "CV", "GW", "MO", "ST", "TL"};
    }

    public Language getDefaultLanguageVariant() {
        return Languages.getLanguageForShortCode((String)"pt-PT");
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Marco A.G. Pinto", "http://www.marcoagpinto.com/"), new Contributor("Susana Boatto (pt-BR)"), new Contributor("Tiago F. Santos (3.6-4.7)", "https://github.com/TiagoSantos81"), new Contributor("Matheus Poletto (pt-BR)", "https://github.com/MatheusPoletto")};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new PortugueseTagger();
    }

    public Disambiguator createDefaultDisambiguator() {
        return new PortugueseHybridDisambiguator(this.getDefaultLanguageVariant());
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new PortugueseWordTokenizer();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return PortugueseSynthesizer.INSTANCE;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikPortugueseSpellerRule(messages, this, null, null);
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"Tomamos caf\u00e9<marker> ,</marker> queijo, bolachas e uvas."), Example.fixed((String)"Tomamos caf\u00e9<marker>,</marker> queijo, bolachas e uvas.")), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\"", "\u201c"), Arrays.asList("]", ")", "}", "\"", "\u201d")), new MorfologikPortugueseSpellerRule(messages, this, userConfig, altLanguages), new LongSentenceRule(messages, userConfig, 50), new LongParagraphRule(messages, (Language)this, userConfig), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Esta casa \u00e9 velha. <marker>foi</marker> construida em 1950."), Example.fixed((String)"Esta casa \u00e9 velha. <marker>Foi</marker> construida em 1950.")), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new ParagraphRepeatBeginningRule(messages, (Language)this), new PunctuationMarkAtParagraphEnd(messages, (Language)this, true), new PostReformPortugueseCompoundRule(messages, this, userConfig), new PortugueseColourHyphenationRule(messages, this, userConfig), new PortugueseReplaceRule(messages, this), new PortugueseBarbarismsRule(messages, "/pt/barbarisms.txt", this), new PortugueseClicheRule(messages, "/pt/cliches.txt", this), new PortugueseFillerWordsRule(messages, this, userConfig), new PortugueseRedundancyRule(messages, "/pt/redundancies.txt", this), new PortugueseWordinessRule(messages, "/pt/wordiness.txt", this), new PortugueseWikipediaRule(messages, "/pt/wikipedia.txt", this), new PortugueseWordRepeatRule(messages, this), new PortugueseWordRepeatBeginningRule(messages, this), new PortugueseAccentuationCheckRule(messages), new PortugueseDiacriticsRule(messages), new PortugueseWrongWordInContextRule(messages, this), new PortugueseWordCoherencyRule(messages), new PortugueseUnitConversionRule(messages), new PortugueseReadabilityRule(messages, this, userConfig, true), new PortugueseReadabilityRule(messages, this, userConfig, false), new DoublePunctuationRule(messages)});
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new PortugueseConfusionProbabilityRule(messages, languageModel, this)});
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public String getOpeningDoubleQuote() {
        return "\u201c";
    }

    public String getClosingDoubleQuote() {
        return "\u201d";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public Map<String, Integer> getPriorityMap() {
        return id2prio;
    }

    protected int getPriorityForId(String id) {
        if (id.startsWith("MORFOLOGIK_RULE")) {
            return -50;
        }
        if (id.startsWith("AI_PT_GGEC_REPLACEMENT_ORTHOGRAPHY_SPELL")) {
            return -49;
        }
        if (id.startsWith("PT_MULTITOKEN_SPELLING")) {
            return -49;
        }
        Integer prio = id2prio.get(id);
        if (prio != null) {
            return prio;
        }
        if (id.startsWith("AI_PT_HYDRA_LEO")) {
            if (id.startsWith("AI_PT_HYDRA_LEO_MISSING_COMMA")) {
                return -51;
            }
            return -51;
        }
        return super.getPriorityForId(id);
    }

    public List<String> prepareLineForSpeller(String line) {
        String[] parts = line.split("#");
        if (parts.length == 0) {
            return Arrays.asList(line);
        }
        String[] formTag = parts[0].split("[\t;]");
        String form = formTag[0].trim();
        if (formTag.length > 1) {
            String tag = formTag[1].trim();
            if (tag.startsWith("N") || tag.equals("_Latin_")) {
                return Arrays.asList(form);
            }
            return Arrays.asList("");
        }
        return Arrays.asList(line);
    }

    public MultitokenSpeller getMultitokenSpeller() {
        return PortugueseMultitokenSpeller.INSTANCE;
    }

    static {
        id2prio.put("FRAGMENT_TWO_ARTICLES", 50);
        id2prio.put("DEGREE_MINUTES_SECONDS", 30);
        id2prio.put("INTERJECTIONS_PUNTUATION", 20);
        id2prio.put("CONFUSION_POR_P\u00d4R_V2", 10);
        id2prio.put("PARONYM_POLITICA_523", 10);
        id2prio.put("PARONYM_PRONUNCIA_262", 10);
        id2prio.put("PARONYM_CRITICA_397", 10);
        id2prio.put("PARONYM_INICIO_169", 10);
        id2prio.put("LP_PARONYMS", 10);
        id2prio.put("PARONYM_MUSICO_499_bis", 10);
        id2prio.put("NA_N\u00c3O", 10);
        id2prio.put("VERB_COMMA_CONJUNCTION", 10);
        id2prio.put("HOMOPHONE_AS_CARD", 5);
        id2prio.put("TODOS_FOLLOWED_BY_NOUN_PLURAL", 3);
        id2prio.put("TODOS_FOLLOWED_BY_NOUN_SINGULAR", 2);
        id2prio.put("AUSENCIA_VIRGULA", 1);
        id2prio.put("EMAIL", 1);
        id2prio.put("UNPAIRED_BRACKETS", -5);
        id2prio.put("PROFANITY", -6);
        id2prio.put("PT_BARBARISMS_REPLACE", -10);
        id2prio.put("BARBARISMS_PT_PT_V3", -10);
        id2prio.put("PT_PT_SIMPLE_REPLACE", -11);
        id2prio.put("PT_REDUNDANCY_REPLACE", -12);
        id2prio.put("PT_WORDINESS_REPLACE", -13);
        id2prio.put("PT_CLICHE_REPLACE", -17);
        id2prio.put("INTERNET_ABBREVIATIONS", -24);
        id2prio.put("CHILDISH_LANGUAGE", -25);
        id2prio.put("ARCHAISMS", -26);
        id2prio.put("INFORMALITIES", -27);
        id2prio.put("BIASED_OPINION_WORDS", -31);
        id2prio.put("PT_AGREEMENT_REPLACE", -35);
        id2prio.put("CONTA_TO", -44);
        id2prio.put("PT_DIACRITICS_REPLACE", -45);
        id2prio.put("DIACRITICS", -45);
        id2prio.put("PT_COMPOUNDS_POST_REFORM", -45);
        id2prio.put("AUX_VERBO", -45);
        id2prio.put("ENSINO_A_DISTANCIA", -45);
        id2prio.put("OQ_O_QUE_ORTHOGRAPHY", -45);
        id2prio.put("EMAIL_SEM_HIFEN_ORTHOGRAPHY", -45);
        id2prio.put("PRETERITO_PERFEITO", -51);
        id2prio.put("PT_BR_SIMPLE_REPLACE", -51);
        id2prio.put("CRASE_CONFUSION", -54);
        id2prio.put("NAO_MILITARES", -54);
        id2prio.put("NA_QUELE", -54);
        id2prio.put("NOTAS_FICAIS", -54);
        id2prio.put("GENERAL_VERB_AGREEMENT_ERRORS", -55);
        id2prio.put("GENERAL_NUMBER_AGREEMENT_ERRORS", -56);
        id2prio.put("GENERAL_GENDER_NUMBER_AGREEMENT_ERRORS", -56);
        id2prio.put("FINAL_STOPS", -75);
        id2prio.put("EU_N\u00d3S_REMOVAL", -90);
        id2prio.put("COLOCA\u00c7\u00c3O_ADV\u00c9RBIO", -90);
        id2prio.put("FAZER_USO_DE-USAR-RECORRER", -90);
        id2prio.put("FORMAL_T-V_DISTINCTION", -100);
        id2prio.put("FORMAL_T-V_DISTINCTION_ALL", -101);
        id2prio.put("REPEATED_WORDS", -210);
        id2prio.put("PT_WIKIPEDIA_COMMON_ERRORS", -500);
        id2prio.put("FILLER_WORDS_PT", -990);
        id2prio.put("TOO_LONG_SENTENCE", -997);
        id2prio.put("TOO_LONG_PARAGRAPH", -998);
        id2prio.put("READABILITY_RULE_SIMPLE_PT", -1100);
        id2prio.put("READABILITY_RULE_DIFFICULT_PT", -1101);
        id2prio.put("UNKNOWN_WORD", -2000);
    }
}

