/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.Rule;
import org.languagetool.rules.pt.BrazilianPortugueseReplaceRule;
import org.languagetool.rules.pt.PortugueseArchaismsRule;
import org.languagetool.rules.pt.PortugueseBarbarismsRule;
import org.languagetool.rules.pt.PortugueseClicheRule;
import org.languagetool.rules.pt.PortugueseRedundancyRule;
import org.languagetool.rules.pt.PortugueseWikipediaRule;
import org.languagetool.rules.pt.PortugueseWordinessRule;
import org.languagetool.rules.pt.PostReformPortugueseCompoundRule;
import org.languagetool.rules.pt.PostReformPortugueseDashRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;

public class BrazilianPortuguese
extends Portuguese {
    @Override
    public String getName() {
        return "Portuguese (Brazil)";
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new PostReformPortugueseCompoundRule(messages, this, userConfig));
        rules.add((Rule)new PostReformPortugueseDashRule(messages));
        rules.add((Rule)new BrazilianPortugueseReplaceRule(messages, "/pt/pt-BR/replace.txt", this));
        rules.add((Rule)new PortugueseBarbarismsRule(messages, "/pt/pt-BR/barbarisms.txt", this));
        rules.add((Rule)new PortugueseArchaismsRule(messages, "/pt/pt-BR/archaisms.txt", this));
        rules.add((Rule)new PortugueseClicheRule(messages, "/pt/pt-BR/cliches.txt", this));
        rules.add((Rule)new PortugueseRedundancyRule(messages, "/pt/pt-BR/redundancies.txt", this));
        rules.add((Rule)new PortugueseWordinessRule(messages, "/pt/pt-BR/wordiness.txt", this));
        rules.add((Rule)new PortugueseWikipediaRule(messages, "/pt/pt-BR/wikipedia.txt", this));
        return rules;
    }

    @Override
    public String[] getCountries() {
        return new String[]{"BR"};
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) {
        return new HunspellRule(messages, (Language)this, null, null);
    }
}

