/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String PORTUGUESE_SIMPLE_REPLACE_RULE = "PT_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = PortugueseReplaceRule.loadFromPath((String)"/pt/replace.txt");
    private static final Locale PT_LOCALE = new Locale("pt");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public PortugueseReplaceRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
    }

    public String getId() {
        return PORTUGUESE_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Palavras estrangeiras facilmente confundidas em Portugu\u00eas";
    }

    public String getShort() {
        return "Estrangeirismo";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "'" + tokenStr + "' \u00e9 um estrangeirismo. Em Portugu\u00eas \u00e9 mais comum usar: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Estrangeirismo");
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

