/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.Calendar;
import java.util.Locale;

class DateFilterHelper {
    DateFilterHelper() {
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.UK);
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.equals("dom") || day.equals("domingo")) {
            return 1;
        }
        if (day.equals("seg") || day.equals("segunda")) {
            return 2;
        }
        if (day.equals("ter") || day.equals("ter\u00e7a")) {
            return 3;
        }
        if (day.equals("qua") || day.equals("quarta")) {
            return 4;
        }
        if (day.equals("qui") || day.equals("quinta")) {
            return 5;
        }
        if (day.equals("sex") || day.equals("sexta")) {
            return 6;
        }
        if (day.equals("s\u00e1b") || day.equals("s\u00e1bado")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        String englishDay = date.getDisplayName(7, 2, Locale.UK);
        if (englishDay.equals("Sunday")) {
            return "domingo";
        }
        if (englishDay.equals("Monday")) {
            return "segunda-feira";
        }
        if (englishDay.equals("Tuesday")) {
            return "ter\u00e7a-feira";
        }
        if (englishDay.equals("Wednesday")) {
            return "quarta-feira";
        }
        if (englishDay.equals("Thursday")) {
            return "quinta-feira";
        }
        if (englishDay.equals("Friday")) {
            return "sexta-feira";
        }
        if (englishDay.equals("Saturday")) {
            return "s\u00e1bado";
        }
        return "";
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.startsWith("jan")) {
            return 1;
        }
        if (mon.startsWith("fev")) {
            return 2;
        }
        if (mon.startsWith("mar")) {
            return 3;
        }
        if (mon.startsWith("abr")) {
            return 4;
        }
        if (mon.startsWith("mai")) {
            return 5;
        }
        if (mon.startsWith("jun")) {
            return 6;
        }
        if (mon.startsWith("jul")) {
            return 7;
        }
        if (mon.startsWith("ago")) {
            return 8;
        }
        if (mon.startsWith("set")) {
            return 9;
        }
        if (mon.startsWith("out")) {
            return 10;
        }
        if (mon.startsWith("nov")) {
            return 11;
        }
        if (mon.startsWith("dez")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

