/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class PortugueseReplaceRule2
extends AbstractSimpleReplaceRule2 {
    public static final String PORTUGUESE_MULTI_REPLACE_RULE = "PT_MULTI_REPLACE";
    private static final String FILE_NAME = "/pt/replace_multi.txt";
    private static final Locale PT_LOCALE = new Locale("pt");

    public final String getFileName() {
        return FILE_NAME;
    }

    public PortugueseReplaceRule2(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Portuguese());
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"<marker>curriculum vitae</marker>"), Example.fixed((String)"<marker>curr\u00edculo</marker>"));
    }

    public final String getId() {
        return PORTUGUESE_MULTI_REPLACE_RULE;
    }

    public String getDescription() {
        return "Palavras de origem estrangeira evit\u00e1veis";
    }

    public String getShort() {
        return "Estrangeirismo";
    }

    public String getSuggestion() {
        return " \u00e9 um estrangeirismo. \u00c9 prefer\u00edvel dizer ";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

