/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class PortugalPortugueseReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String PORTUGAL_PORTUGUESE_SIMPLE_REPLACE_RULE = "PT_PT_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = PortugalPortugueseReplaceRule.load((String)"/pt/pt-PT/replace.txt");
    private static final Locale PT_PT_LOCALE = new Locale("pt-PT");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public PortugalPortugueseReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"Onde est\u00e1 o <marker>banheiro</marker>?"), Example.fixed((String)"Onde est\u00e1 o <marker>toilet</marker>?"));
    }

    public final String getId() {
        return PORTUGAL_PORTUGUESE_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Palavras brasileiras facilmente confundidas com as de Portugal";
    }

    public String getShort() {
        return "Palavra brasileira";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " \u00e9 uma express\u00e3o brasileira, em Portugu\u00eas de Portugal utiliza-se: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return PT_PT_LOCALE;
    }
}

