/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.PortuguesePortugal;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.pt.PortugueseCompoundRule;
import org.languagetool.rules.spelling.hunspell.HunspellNoSuggestionRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Portuguese
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;

    public String getName() {
        return "Portuguese";
    }

    public String getShortName() {
        return "pt";
    }

    public String[] getCountries() {
        return new String[]{"AO", "MZ"};
    }

    public Language getDefaultLanguageVariant() {
        return new PortuguesePortugal();
    }

    public Contributor[] getMaintainers() {
        Contributor contributor = new Contributor("Marco A.G. Pinto");
        contributor.setUrl("http://www.marcoagpinto.com/");
        return new Contributor[]{contributor};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new DemoTagger();
        }
        return this.tagger;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, DoublePunctuationRule.class, GenericUnpairedBracketsRule.class, HunspellNoSuggestionRule.class, UppercaseSentenceStartRule.class, WordRepeatRule.class, WhitespaceRule.class, PortugueseCompoundRule.class);
    }
}

