/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.pl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class PolishTagger
extends BaseTagger {
    public PolishTagger() {
        super("/pl/polish.dict", new Locale("pl"));
    }

    public final List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
            List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
            boolean isLowercase = word.equals(lowerWord);
            this.addTokens(taggerTokens, l);
            if (!isLowercase) {
                this.addTokens(lowerTaggerTokens, l);
            }
            if (lowerTaggerTokens.isEmpty() && taggerTokens.isEmpty()) {
                if (isLowercase) {
                    List upperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(StringTools.uppercaseFirstChar((String)word)));
                    if (!upperTaggerTokens.isEmpty()) {
                        this.addTokens(upperTaggerTokens, l);
                    } else {
                        l.add(new AnalyzedToken(word, null, null));
                    }
                } else {
                    l.add(new AnalyzedToken(word, null, null));
                }
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            for (AnalyzedToken at : taggedTokens) {
                String[] tagsArr;
                for (String currTag : tagsArr = StringTools.asString((CharSequence)at.getPOSTag()).split("\\+")) {
                    l.add(new AnalyzedToken(at.getToken(), currTag, at.getLemma()));
                }
            }
        }
    }
}

