/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.pl.CompoundRule;
import org.languagetool.rules.pl.DashRule;
import org.languagetool.rules.pl.MorfologikPolishSpellerRule;
import org.languagetool.rules.pl.PolishUnpairedBracketsRule;
import org.languagetool.rules.pl.PolishWordRepeatRule;
import org.languagetool.rules.pl.SimpleReplaceRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.pl.PolishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.pl.PolishHybridDisambiguator;
import org.languagetool.tagging.pl.PolishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.pl.PolishWordTokenizer;

public class Polish
extends Language {
    public String getName() {
        return "Polish";
    }

    public String getShortCode() {
        return "pl";
    }

    public String[] getCountries() {
        return new String[]{"PL"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new PolishTagger();
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        PolishWordTokenizer wordTokenizer = new PolishWordTokenizer();
        wordTokenizer.setTagger(this.getTagger());
        return wordTokenizer;
    }

    public Disambiguator createDefaultDisambiguator() {
        return new PolishHybridDisambiguator();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new PolishSynthesizer(this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.MARCIN_MILKOWSKI};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new UppercaseSentenceStartRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new PolishUnpairedBracketsRule(messages, this), new MorfologikPolishSpellerRule(messages, this, userConfig, altLanguages), new PolishWordRepeatRule(messages), new CompoundRule(messages), new SimpleReplaceRule(messages), new DashRule(messages)});
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }
}

