/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pl;

import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public class DecadeSpellingFilter
extends RuleFilter {
    private static int[] numbers = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static String[] letters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    private String getRomanNumber(int num) {
        String roman = "";
        int N = num;
        for (int i = 0; i < numbers.length; ++i) {
            while (N >= numbers[i]) {
                roman = roman + letters[i];
                N -= numbers[i];
            }
        }
        return roman;
    }

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, AnalyzedTokenReadings[] patternTokens) {
        try {
            String decade = arguments.get("lata").substring(2);
            String century = arguments.get("lata").substring(0, 2);
            int cent = Integer.parseInt(century);
            String message = match.getMessage().replace("{dekada}", decade).replace("{wiek}", this.getRomanNumber(cent + 1));
            RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage(), match.getFromPos() == 0, null);
            ruleMatch.setType(match.getType());
            return ruleMatch;
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }
}

