/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pl;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String POLISH_SIMPLE_REPLACE_RULE = "PL_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = SimpleReplaceRule.load((String)"/pl/replace.txt");
    private static final Locale PL_LOCALE = new Locale("pl");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setCategory(new Category(new CategoryId("PRAWDOPODOBNE_LITEROWKI"), "Prawdopodobne liter\u00f3wki"));
        this.setCheckLemmas(false);
        this.addExamplePair(Example.wrong((String)"Uspok\u00f3j <marker>sei</marker>."), Example.fixed((String)"Uspok\u00f3j <marker>si\u0119</marker>."));
    }

    public final String getId() {
        return POLISH_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Typowe liter\u00f3wki i niepoprawne wyrazy (domowi, sie, niewiadomo, duh, cie\u2026)";
    }

    public String getShort() {
        return "Liter\u00f3wka";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " to najcz\u0119\u015bciej b\u0142\u0105d; poprawnie pisze si\u0119: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return PL_LOCALE;
    }
}

