/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pl;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.languagetool.rules.AbstractSimpleReplaceRule;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String POLISH_SIMPLE_REPLACE_RULE = "PL_SIMPLE_REPLACE";
    private static final String FILE_NAME = "/pl/replace.txt";
    private static final Locale PL_LOCALE = new Locale("pl");

    public final String getFileName() {
        return FILE_NAME;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType("misspelling");
    }

    public final String getId() {
        return POLISH_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Typowe liter\u00f3wki";
    }

    public String getShort() {
        return "Liter\u00f3wka";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " to typowa liter\u00f3wka, poprawnie: " + StringUtils.join(replacements, (String)", ") + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return PL_LOCALE;
    }
}

