/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.pl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.DictionaryLookup;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class PolishTagger
extends BaseTagger {
    private static final String RESOURCE_FILENAME = "/pl/polish.dict";
    private final Locale plLocale = new Locale("pl");

    public final String getFileName() {
        return RESOURCE_FILENAME;
    }

    public final List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup morfologik = new DictionaryLookup(this.getDictionary());
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.plLocale);
            List taggerTokens = this.asAnalyzedTokenList(word, morfologik.lookup((CharSequence)word));
            List lowerTaggerTokens = this.asAnalyzedTokenList(word, morfologik.lookup((CharSequence)lowerWord));
            boolean isLowercase = word.equals(lowerWord);
            this.addTokens(taggerTokens, l);
            if (!isLowercase) {
                this.addTokens(lowerTaggerTokens, l);
            }
            if (lowerTaggerTokens.isEmpty() && taggerTokens.isEmpty()) {
                if (isLowercase) {
                    List upperTaggerTokens = this.asAnalyzedTokenList(word, morfologik.lookup((CharSequence)StringTools.uppercaseFirstChar((String)word)));
                    if (!upperTaggerTokens.isEmpty()) {
                        this.addTokens(upperTaggerTokens, l);
                    } else {
                        l.add(new AnalyzedToken(word, null, null));
                    }
                } else {
                    l.add(new AnalyzedToken(word, null, null));
                }
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            for (AnalyzedToken at : taggedTokens) {
                String[] tagsArr;
                for (String currTag : tagsArr = StringTools.asString((CharSequence)at.getPOSTag()).split("\\+")) {
                    l.add(new AnalyzedToken(at.getToken(), currTag, at.getLemma()));
                }
            }
        }
    }
}

