/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.nl.MorfologikDutchSpellerRule;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.tagging.nl.DutchTagger;

public class CompoundAcceptor {
    private static final Pattern acronymPattern = Pattern.compile("[A-Z]{2,4}-");
    private static final Pattern specialAcronymPattern = Pattern.compile("[A-Za-z]{2,4}-");
    private static final Pattern normalCasePattern = Pattern.compile("[A-Za-z][a-z\u00e9]*");
    private static final int MAX_WORD_SIZE = 35;
    public static final CompoundAcceptor INSTANCE = new CompoundAcceptor();
    protected final CachingWordListLoader wordListLoader = new CachingWordListLoader();
    protected final Set<String> noS = new ObjectOpenHashSet();
    protected final Set<String> needsS = new ObjectOpenHashSet();
    protected final Set<String> geographicalDirections = new ObjectOpenHashSet();
    protected final Set<String> alwaysNeedsS = new ObjectOpenHashSet();
    protected final Set<String> alwaysNeedsHyphen = new ObjectOpenHashSet();
    protected final Set<String> part1Exceptions = new ObjectOpenHashSet();
    protected final Set<String> part2Exceptions = new ObjectOpenHashSet();
    protected final Set<String> acronymExceptions = new ObjectOpenHashSet();
    private static final String COMPOUND_NO_S_FILE = "nl/compound_acceptor/no_s.txt";
    private static final String COMPOUND_NEEDS_S_FILE = "nl/compound_acceptor/needs_s.txt";
    private static final String COMPOUND_DIRECTIONS_FILE = "nl/compound_acceptor/directions.txt";
    private static final String COMPOUND_ALWAYS_NEEDS_S_FILE = "nl/compound_acceptor/always_needs_s.txt";
    private static final String COMPOUND_ALWAYS_NEEDS_HYPHEN_FILE = "nl/compound_acceptor/always_needs_hyphen.txt";
    private static final String COMPOUND_PART1_EXCEPTIONS_FILE = "nl/compound_acceptor/part1_exceptions.txt";
    private static final String COMPOUND_PART2_EXCEPTIONS_FILE = "nl/compound_acceptor/part2_exceptions.txt";
    private static final String COMPOUND_ACRONYM_EXCEPTIONS_FILE = "nl/compound_acceptor/acronym_exceptions.txt";
    private final Set<String> collidingVowels = ImmutableSet.of((Object)"aa", (Object)"ae", (Object)"ai", (Object)"au", (Object)"ee", (Object)"\u00e9e", (Object[])new String[]{"ei", "\u00e9i", "eu", "\u00e9u", "ie", "ii", "ij", "oe", "oi", "oo", "ou", "ui", "uu"});
    private static final MorfologikDutchSpellerRule speller;
    private final DutchTagger dutchTagger = DutchTagger.INSTANCE;

    public CompoundAcceptor() {
        this.noS.addAll(this.wordListLoader.loadWords(COMPOUND_NO_S_FILE));
        this.needsS.addAll(this.wordListLoader.loadWords(COMPOUND_NEEDS_S_FILE));
        this.geographicalDirections.addAll(this.wordListLoader.loadWords(COMPOUND_DIRECTIONS_FILE));
        this.alwaysNeedsS.addAll(this.wordListLoader.loadWords(COMPOUND_ALWAYS_NEEDS_S_FILE));
        this.alwaysNeedsHyphen.addAll(this.wordListLoader.loadWords(COMPOUND_ALWAYS_NEEDS_HYPHEN_FILE));
        this.part1Exceptions.addAll(this.wordListLoader.loadWords(COMPOUND_PART1_EXCEPTIONS_FILE));
        this.part2Exceptions.addAll(this.wordListLoader.loadWords(COMPOUND_PART2_EXCEPTIONS_FILE));
        this.acronymExceptions.addAll(this.wordListLoader.loadWords(COMPOUND_ACRONYM_EXCEPTIONS_FILE));
    }

    boolean acceptCompound(String word) {
        if (word.length() > 35) {
            return false;
        }
        for (int i = 3; i < word.length() - 3; ++i) {
            String part2;
            String part1 = word.substring(0, i);
            if (part1.equals(part2 = word.substring(i)) || !this.acceptCompound(part1, part2)) continue;
            return true;
        }
        return false;
    }

    public List<String> getParts(String word) {
        if (word.length() > 35) {
            return Collections.emptyList();
        }
        for (int i = 3; i < word.length() - 3; ++i) {
            String part2;
            String part1 = word.substring(0, i);
            if (part1.equals(part2 = word.substring(i)) || !this.acceptCompound(part1, part2)) continue;
            return Arrays.asList(part1, part2);
        }
        return Collections.emptyList();
    }

    boolean acceptCompound(String part1, String part2) {
        try {
            String part1lc = part1.toLowerCase();
            if (!(!part1.endsWith("s") || this.part1Exceptions.contains(part1.substring(0, part1.length() - 1)) || this.alwaysNeedsS.contains(part1) || this.noS.contains(part1) || part1.contains("-"))) {
                for (String suffix : this.alwaysNeedsS) {
                    if (!part1lc.endsWith(suffix)) continue;
                    return this.isNoun(part2) && this.isExistingWord(part1lc.substring(0, part1lc.length() - 1)) && this.spellingOk(part2);
                }
                return this.needsS.contains(part1lc) && this.isNoun(part2) && this.spellingOk(part1.substring(0, part1.length() - 1)) && this.spellingOk(part2);
            }
            if (this.geographicalDirections.contains(part1)) {
                return this.isGeographicalCompound(part2);
            }
            if (part1.endsWith("-")) {
                return (this.acronymOk(part1) || this.alwaysNeedsHyphen.contains(part1lc)) && this.spellingOk(part2);
            }
            if (part2.startsWith("-")) {
                part2 = part2.substring(1);
                return this.noS.contains(part1lc) && this.isNoun(part2) && this.spellingOk(part1) && this.spellingOk(part2) && this.hasCollidingVowels(part1, part2);
            }
            return (this.noS.contains(part1lc) || this.part1Exceptions.contains(part1lc)) && this.isNoun(part2) && this.spellingOk(part1) && !this.hasCollidingVowels(part1, part2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isNoun(String word) throws IOException {
        return this.dutchTagger.getPostags(word).stream().anyMatch(k -> {
            assert (k.getPOSTag() != null);
            return k.getPOSTag().startsWith("ZNW") && !this.part2Exceptions.contains(word);
        });
    }

    private boolean isExistingWord(String word) throws IOException {
        return this.dutchTagger.getPostags(word).stream().anyMatch(k -> k.getPOSTag() != null);
    }

    private boolean isGeographicalCompound(String word) throws IOException {
        return this.dutchTagger.getPostags(word).stream().anyMatch(k -> {
            assert (k.getPOSTag() != null);
            return k.getPOSTag().startsWith("ENM:LOC");
        });
    }

    private boolean hasCollidingVowels(String part1, String part2) {
        char char1 = part1.charAt(part1.length() - 1);
        char char2 = part2.charAt(0);
        String vowels = String.valueOf(char1) + char2;
        return this.collidingVowels.contains(vowels.toLowerCase());
    }

    private boolean acronymOk(String nonCompound) {
        if (acronymPattern.matcher(nonCompound).matches()) {
            return this.acronymExceptions.stream().noneMatch(exception -> exception.toUpperCase().equals(nonCompound.substring(0, nonCompound.length() - 1)));
        }
        if (specialAcronymPattern.matcher(nonCompound).matches()) {
            return this.acronymExceptions.contains(nonCompound.substring(0, nonCompound.length() - 1));
        }
        return false;
    }

    private boolean spellingOk(String nonCompound) throws IOException {
        if (!normalCasePattern.matcher(nonCompound).matches()) {
            return false;
        }
        AnalyzedSentence as = new AnalyzedSentence(new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken(nonCompound.toLowerCase(), "FAKE_POS", "fakeLemma"))});
        RuleMatch[] matches = speller.match(as);
        return matches.length == 0;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + CompoundAcceptor.class.getName() + " <file>");
            System.exit(1);
        }
        CompoundAcceptor acceptor = new CompoundAcceptor();
        List<String> words = Files.readAllLines(Paths.get(args[0], new String[0]));
        for (String word : words) {
            boolean accepted = acceptor.acceptCompound(word);
            System.out.println(accepted + " " + word);
        }
    }

    static {
        try {
            speller = new MorfologikDutchSpellerRule(JLanguageTool.getMessageBundle(), Languages.getLanguageForShortCode((String)"nl"), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

