/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SpecificIdRule;
import org.languagetool.rules.nl.Tools;
import org.languagetool.tools.StringTools;

public class SpaceInCompoundRule
extends Rule {
    private static final Map<String, String> normalizedCompound2message = new HashMap<String, String>();
    private static final AhoCorasickDoubleArrayTrie<String> trie = SpaceInCompoundRule.getTrie();
    private static final Pattern chars = Pattern.compile("[a-zA-Z]");
    private final Language language;

    public SpaceInCompoundRule(ResourceBundle messages, Language language) {
        this.language = language;
    }

    private static AhoCorasickDoubleArrayTrie<String> getTrie() {
        HashSet<String> result = new HashSet<String>();
        String filename = "/nl/multipartcompounds.txt";
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(filename);
        for (Object line : lines) {
            boolean hasDuplicate;
            if (((String)line).startsWith("#")) continue;
            String[] lineParts = ((String)line).split("\\|");
            String wordParts = lineParts[0];
            if (!wordParts.contains(" ")) {
                throw new RuntimeException("Unexpected format in " + filename + ", expected multi-word (i.e. spaces) left of the '|': " + (String)line);
            }
            String[] words = wordParts.split(" ");
            SpaceInCompoundRule.generateVariants("", Arrays.asList(words), result);
            boolean bl = hasDuplicate = lines.indexOf(wordParts) != lines.lastIndexOf(wordParts);
            if (hasDuplicate) {
                throw new RuntimeException("Duplicate item '" + wordParts + "' in file " + filename);
            }
            String message = "Waarschijnlijk bedoelt u: " + Tools.glueParts(words);
            if (lineParts.length == 2) {
                message = message + " (" + lineParts[1] + ")";
            }
            normalizedCompound2message.put(Tools.glueParts(words), message);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String variant : result) {
            map.put(variant, variant);
        }
        AhoCorasickDoubleArrayTrie trie = new AhoCorasickDoubleArrayTrie();
        trie.build(map);
        return trie;
    }

    static void generateVariants(String soFar, List<String> l, Set<String> result) {
        if (l.size() == 1) {
            if (soFar.contains(" ")) {
                result.add(soFar + l.get(0));
            }
            result.add(soFar + " " + l.get(0));
        } else {
            List<String> rest = l.subList(1, l.size());
            SpaceInCompoundRule.generateVariants(soFar + l.get(0), rest, result);
            if (!soFar.isEmpty()) {
                SpaceInCompoundRule.generateVariants(soFar + " " + l.get(0), rest, result);
            }
        }
    }

    public String getId() {
        return "NL_SPACE_IN_COMPOUND";
    }

    public String getDescription() {
        return "Detecteert spatiefouten";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = sentence.getText();
        List hits = trie.parseText((CharSequence)text);
        for (AhoCorasickDoubleArrayTrie.Hit hit : hits) {
            String coveredNoSpaces;
            String message;
            String covered = text.substring(hit.begin, hit.end);
            if (hit.begin > 0 && !this.isBoundary(text.substring(hit.begin - 1, hit.begin)) || hit.end < text.length() && !this.isBoundary(text.substring(hit.end, hit.end + 1)) || (message = normalizedCompound2message.get(coveredNoSpaces = Tools.glueParts(covered.split(" ")))) == null) continue;
            String id = StringTools.toId((String)(this.getId() + "_" + covered), (Language)this.language);
            SpecificIdRule specificIdRule = new SpecificIdRule(id, this.getDescription(), this.isPremium(), this.getCategory(), this.getLocQualityIssueType(), this.getTags());
            RuleMatch match = new RuleMatch((Rule)specificIdRule, sentence, hit.begin, hit.end, hit.begin, hit.end, message, null, false, "");
            match.setSuggestedReplacement(coveredNoSpaces);
            matches.add(match);
        }
        return this.toRuleMatchArray(matches);
    }

    private boolean isBoundary(String s) {
        return !chars.matcher(s).matches();
    }
}

