/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.nl.PreferredWordData;
import org.languagetool.rules.nl.PreferredWordRuleWithSuggestion;

public class PreferredWordRule
extends Rule {
    private static final String DESC = "Suggereert een gebruikelijker woord.";
    private static final String RULE_ID = "NL_PREFERRED_WORD_RULE";
    private static final PreferredWordData data = new PreferredWordData("Suggereert een gebruikelijker woord.", "/nl/preferredwords.csv", "NL_PREFERRED_WORD_RULE");

    public PreferredWordRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"Hij vindt <marker>rijwiel</marker> een ouderwets woord."), Example.fixed((String)"En ik vind <marker>fiets</marker> ook beter."));
    }

    public String getId() {
        return RULE_ID;
    }

    public String getDescription() {
        return DESC;
    }

    public int estimateContextForSureMatch() {
        return 1;
    }

    protected PreferredWordData getData() {
        return data;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (PreferredWordRuleWithSuggestion ruleWithSuggestion : this.getData().get()) {
            Rule rule = ruleWithSuggestion.rule;
            RuleMatch[] matches = rule.match(sentence);
            if (matches.length <= 0) continue;
            RuleMatch match = matches[0];
            String matchedText = sentence.getText().substring(match.getFromPos(), match.getToPos());
            String suggestion = matchedText.replace(ruleWithSuggestion.oldWord, ruleWithSuggestion.newWord);
            if (suggestion.equals(matchedText)) continue;
            match.setSuggestedReplacement(suggestion);
            ruleMatches.addAll(Arrays.asList(matches));
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

