/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

class Tools {
    private static final String spelledWords = "abc|adv|aed|apk|b2b|bh|bhv|bso|btw|bv|cao|cd|cfk|ckv|cv|dc|dj|dtp|dvd|fte|gft|ggo|ggz|gm|gmo|gps|gsm|hbo|hd|hiv|hr|hrm|hst|ic|ivf|kmo|lcd|lp|lpg|lsd|mbo|mdf|mkb|mms|msn|mt|ngo|nv|ob|ov|ozb|p2p|pc|pcb|pdf|pk|pps|pr|pvc|roc|rvs|sms|tbc|tbs|tl|tv|uv|vbo|vj|vmbo|vsbo|vwo|wc|wo|xtc|zzp";
    private static final Set<String> spelledWordsSet = new HashSet<String>(Arrays.asList("abc|adv|aed|apk|b2b|bh|bhv|bso|btw|bv|cao|cd|cfk|ckv|cv|dc|dj|dtp|dvd|fte|gft|ggo|ggz|gm|gmo|gps|gsm|hbo|hd|hiv|hr|hrm|hst|ic|ivf|kmo|lcd|lp|lpg|lsd|mbo|mdf|mkb|mms|msn|mt|ngo|nv|ob|ov|ozb|p2p|pc|pcb|pdf|pk|pps|pr|pvc|roc|rvs|sms|tbc|tbs|tl|tv|uv|vbo|vj|vmbo|vsbo|vwo|wc|wo|xtc|zzp".split("\\|")));
    private static final Pattern ENDS_IN_DIGIT = Pattern.compile(".*[0-9]$");
    private static final Pattern STARTS_WITH_DIGIT = Pattern.compile("^[0-9].*");
    private static final Pattern ENDS_IN_HYPHEN_AND_CHAR = Pattern.compile(".+-[a-z]$");
    private static final Pattern STARTS_WITH_CHAR_AND_HYPHEN = Pattern.compile("^[a-z]-.+");
    private static final Pattern HYPHEN_CHARS = Pattern.compile("(^|.+-)?(abc|adv|aed|apk|b2b|bh|bhv|bso|btw|bv|cao|cd|cfk|ckv|cv|dc|dj|dtp|dvd|fte|gft|ggo|ggz|gm|gmo|gps|gsm|hbo|hd|hiv|hr|hrm|hst|ic|ivf|kmo|lcd|lp|lpg|lsd|mbo|mdf|mkb|mms|msn|mt|ngo|nv|ob|ov|ozb|p2p|pc|pcb|pdf|pk|pps|pr|pvc|roc|rvs|sms|tbc|tbs|tl|tv|uv|vbo|vj|vmbo|vsbo|vwo|wc|wo|xtc|zzp)");
    private static final Pattern CHARS_HYPHEN = Pattern.compile("(abc|adv|aed|apk|b2b|bh|bhv|bso|btw|bv|cao|cd|cfk|ckv|cv|dc|dj|dtp|dvd|fte|gft|ggo|ggz|gm|gmo|gps|gsm|hbo|hd|hiv|hr|hrm|hst|ic|ivf|kmo|lcd|lp|lpg|lsd|mbo|mdf|mkb|mms|msn|mt|ngo|nv|ob|ov|ozb|p2p|pc|pcb|pdf|pk|pps|pr|pvc|roc|rvs|sms|tbc|tbs|tl|tv|uv|vbo|vj|vmbo|vsbo|vwo|wc|wo|xtc|zzp)(-.+|$)?");

    private Tools() {
    }

    static String glueParts(String[] str) {
        return Tools.glueParts(Arrays.asList(str));
    }

    static String glueParts(List<String> s) {
        StringBuilder compound = new StringBuilder(s.get(0));
        for (int i = 1; i < s.size(); ++i) {
            String word2 = s.get(i);
            if (compound.length() > 2 || spelledWordsSet.contains(compound.toString())) {
                char lastChar = compound.charAt(compound.length() - 1);
                char firstChar = word2.charAt(0);
                String connection = lastChar + String.valueOf(firstChar);
                if (StringUtils.containsAny((CharSequence)connection, (CharSequence[])new CharSequence[]{"aa", "ae", "ai", "ao", "au", "ee", "ei", "eu", "\u00e9e", "\u00e9i", "\u00e9u", "ie", "ii", "oe", "oi", "oo", "ou", "ui", "uu", "ij"}) || Character.isUpperCase(firstChar) && Character.isLowerCase(lastChar) || Character.isUpperCase(lastChar) && Character.isLowerCase(firstChar) || Character.isUpperCase(lastChar) && Character.isUpperCase(firstChar) || ENDS_IN_DIGIT.matcher(compound).matches() || STARTS_WITH_DIGIT.matcher(word2).matches() || HYPHEN_CHARS.matcher(compound).matches() || CHARS_HYPHEN.matcher(word2).matches() || ENDS_IN_HYPHEN_AND_CHAR.matcher(compound).matches() || STARTS_WITH_CHAR_AND_HYPHEN.matcher(word2).matches()) {
                    compound.append('-').append(word2);
                    continue;
                }
                compound.append(word2);
                continue;
            }
            compound.append(word2);
        }
        return compound.toString();
    }
}

