/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.rules.AbstractDateCheckWithSuggestionsFilter;

public class DateCheckFilter
extends AbstractDateCheckWithSuggestionsFilter {
    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.UK);
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.equals("zo") || day.equals("zondag")) {
            return 1;
        }
        if (day.equals("ma") || day.equals("maandag")) {
            return 2;
        }
        if (day.equals("di") || day.equals("dinsdag")) {
            return 3;
        }
        if (day.equals("wo") || day.equals("woensdag")) {
            return 4;
        }
        if (day.equals("do") || day.equals("donderdag")) {
            return 5;
        }
        if (day.equals("vr") || day.equals("vrijdag")) {
            return 6;
        }
        if (day.equals("za") || day.equals("zaterdag")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        String englishDay = date.getDisplayName(7, 2, Locale.UK);
        if (englishDay.equals("Sunday")) {
            return "zondag";
        }
        if (englishDay.equals("Monday")) {
            return "maandag";
        }
        if (englishDay.equals("Tuesday")) {
            return "dinsdag";
        }
        if (englishDay.equals("Wednesday")) {
            return "woensdag";
        }
        if (englishDay.equals("Thursday")) {
            return "donderdag";
        }
        if (englishDay.equals("Friday")) {
            return "vrijdag";
        }
        if (englishDay.equals("Saturday")) {
            return "zaterdag";
        }
        return "";
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.startsWith("jan")) {
            return 1;
        }
        if (mon.startsWith("feb")) {
            return 2;
        }
        if (mon.startsWith("maa")) {
            return 3;
        }
        if (mon.startsWith("mrt")) {
            return 3;
        }
        if (mon.startsWith("mar")) {
            return 3;
        }
        if (mon.startsWith("apr")) {
            return 4;
        }
        if (mon.startsWith("mei")) {
            return 5;
        }
        if (mon.startsWith("jun")) {
            return 6;
        }
        if (mon.startsWith("jul")) {
            return 7;
        }
        if (mon.startsWith("aug")) {
            return 8;
        }
        if (mon.startsWith("sep")) {
            return 9;
        }
        if (mon.startsWith("okt") || mon.startsWith("oct")) {
            return 10;
        }
        if (mon.startsWith("nov")) {
            return 11;
        }
        if (mon.startsWith("dec")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }

    protected String getErrorMessageWrongYear() {
        return "Deze datum is onjuist. Bedoelt u misschien \"{currentYear}\"?";
    }
}

