/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.nl.CheckCaseRule;
import org.languagetool.rules.nl.CompoundRule;
import org.languagetool.rules.nl.DutchConfusionProbabilityRule;
import org.languagetool.rules.nl.DutchWrongWordInContextRule;
import org.languagetool.rules.nl.MorfologikDutchSpellerRule;
import org.languagetool.rules.nl.PreferredWordRule;
import org.languagetool.rules.nl.SimpleReplaceRule;
import org.languagetool.rules.nl.SpaceInCompoundRule;
import org.languagetool.rules.nl.WordCoherencyRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.nl.DutchSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.nl.DutchTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.nl.DutchWordTokenizer;

public class Dutch
extends Language {
    private static final Language NETHERLANDS_DUTCH = new Dutch();
    private LanguageModel languageModel;

    public Language getDefaultLanguageVariant() {
        return NETHERLANDS_DUTCH;
    }

    public String getName() {
        return "Dutch";
    }

    public String getShortCode() {
        return "nl";
    }

    public String[] getCountries() {
        return new String[]{"NL", "BE"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new DutchTagger();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return DutchSynthesizer.INSTANCE;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new DutchWordTokenizer();
    }

    public Disambiguator createDefaultDisambiguator() {
        return new XmlRuleDisambiguator((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("OpenTaal", "http://www.opentaal.org"), new Contributor("TaalTik", "http://www.taaltik.nl")};
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201c", "\u2039", "\u201c", "\u201e", "\""), Arrays.asList("]", ")", "}", "\u201d", "\u203a", "\u201d", "\u201d", "\"")), new UppercaseSentenceStartRule(messages, (Language)this), new MorfologikDutchSpellerRule(messages, this, userConfig, altLanguages), new MultipleWhitespaceRule(messages, (Language)this), new CompoundRule(messages, this, userConfig), new DutchWrongWordInContextRule(messages), new WordCoherencyRule(messages), new SimpleReplaceRule(messages), new LongSentenceRule(messages, userConfig, 40), new LongParagraphRule(messages, (Language)this, userConfig), new PreferredWordRule(messages), new SpaceInCompoundRule(messages), new SentenceWhitespaceRule(messages), new CheckCaseRule(messages, this)});
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new DutchConfusionProbabilityRule(messages, languageModel, this)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public String getOpeningDoubleQuote() {
        return "\u201c";
    }

    public String getClosingDoubleQuote() {
        return "\u201d";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    protected int getPriorityForId(String id) {
        if (id.startsWith("NL_SIMPLE_REPLACE")) {
            return -2;
        }
        switch (id) {
            case "TOO_LONG_SENTENCE": {
                return -1;
            }
            case "KORT_1": {
                return -5;
            }
            case "KORT_2": {
                return -5;
            }
            case "EINDE_ZIN_ONVERWACHT": {
                return -5;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
            case "DE_ONVERWACHT": {
                return -20;
            }
            case "TE-VREEMD": {
                return -20;
            }
        }
        if (id.startsWith("AI_NL_HYDRA_LEO")) {
            if (id.startsWith("AI_NL_HYDRA_LEO_MISSING_COMMA")) {
                return -51;
            }
            return -5;
        }
        return super.getPriorityForId(id);
    }

    public List<String> getRuleFileNames() {
        List ruleFileNames = super.getRuleFileNames();
        String dirBase = JLanguageTool.getDataBroker().getRulesDir() + "/" + this.getShortCode() + "/";
        ruleFileNames.add(dirBase + "nl-NL/grammar.xml");
        return ruleFileNames;
    }

    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikDutchSpellerRule(messages, this, null, Collections.emptyList());
    }
}

