/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.nl.Tools;

public class SpaceInCompoundRule
extends Rule {
    private static final Map<String, String> normalizedCompound2message = new HashMap<String, String>();
    private static final AhoCorasickDoubleArrayTrie<String> trie = SpaceInCompoundRule.getTrie();

    public SpaceInCompoundRule(ResourceBundle messages) {
    }

    private static AhoCorasickDoubleArrayTrie<String> getTrie() {
        HashSet<String> result = new HashSet<String>();
        String filename = "/nl/multipartcompounds.txt";
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(filename);
        for (Object line : lines) {
            if (((String)line).startsWith("#")) continue;
            String[] lineParts = ((String)line).split("\\|");
            if (lineParts.length != 2) {
                throw new RuntimeException("Unexpected format in " + filename + ", expected 2 columns separated by '|': " + (String)line);
            }
            String wordParts = lineParts[0];
            String[] words = wordParts.split(" ");
            SpaceInCompoundRule.generateVariants("", Arrays.asList(words), result);
            if (normalizedCompound2message.containsKey(Tools.glueParts(words))) {
                throw new RuntimeException("Duplicate item '" + wordParts + "' in file " + filename);
            }
            String message = "U bedoelt misschien: " + Tools.glueParts(words) + " (" + lineParts[1] + ").";
            normalizedCompound2message.put(Tools.glueParts(words), message);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String variant : result) {
            map.put(variant, variant);
        }
        AhoCorasickDoubleArrayTrie trie = new AhoCorasickDoubleArrayTrie();
        trie.build(map);
        return trie;
    }

    static void generateVariants(String soFar, List<String> l, Set<String> result) {
        if (l.size() == 1) {
            if (soFar.contains(" ")) {
                result.add(soFar + l.get(0));
            }
            result.add(soFar + " " + l.get(0));
        } else {
            List<String> rest = l.subList(1, l.size());
            SpaceInCompoundRule.generateVariants(soFar + l.get(0), rest, result);
            if (!soFar.isEmpty()) {
                SpaceInCompoundRule.generateVariants(soFar + " " + l.get(0), rest, result);
            }
        }
    }

    public String getId() {
        return "NL_SPACE_IN_COMPOUND";
    }

    public String getDescription() {
        return "Detecteert spatiefouten";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = sentence.getText();
        List hits = trie.parseText((CharSequence)text);
        for (AhoCorasickDoubleArrayTrie.Hit hit : hits) {
            String covered = text.substring(hit.begin, hit.end);
            String coveredNoSpaces = Tools.glueParts(covered.split(" "));
            String message = normalizedCompound2message.get(coveredNoSpaces);
            if (message == null) continue;
            RuleMatch match = new RuleMatch((Rule)this, sentence, hit.begin, hit.end, hit.begin, hit.end, message, null, false, "");
            match.setSuggestedReplacement(coveredNoSpaces);
            matches.add(match);
        }
        return this.toRuleMatchArray(matches);
    }
}

