/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.nl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class DutchTagger
extends BaseTagger {
    public DutchTagger() {
        super("/nl/dutch.dict", new Locale("nl"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            boolean ignoreSpelling = false;
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase((String)word);
            boolean isAllUpper = StringTools.isAllUppercase((String)word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
            this.addTokens(taggerTokens, l);
            if (!isLowercase && !isMixedCase) {
                List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
                this.addTokens(lowerTaggerTokens, l);
            }
            if (l.isEmpty() && isAllUpper) {
                String firstUpper = StringTools.uppercaseFirstChar((String)lowerWord);
                List firstupperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(firstUpper));
                this.addTokens(firstupperTaggerTokens, l);
            }
            if (l.isEmpty()) {
                List l2;
                String word2 = lowerWord;
                word2 = word2.replace('\u00e1', 'a').replace('\u00e9', 'e').replace('\u00ed', 'i').replace('\u00f3', 'o').replace('\u00fa', 'u');
                if (!(word2 = word2.replaceAll("([a-z])-([a-z])", "$1$2")).equals(word) && (l2 = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word2))) != null) {
                    this.addTokens(l2, l);
                    String word3 = word;
                    word3 = word.replaceAll("([a-z])-([a-z])", "$1$2");
                    word3 = word3.replace("\u00e1\u00e1", "aa");
                    word3 = word3.replace("\u00e1\u00e9", "ae");
                    word3 = word3.replace("\u00e1\u00ed", "ai");
                    word3 = word3.replace("\u00e1\u00fa", "au");
                    word3 = word3.replace("\u00e9\u00e9", "ee");
                    word3 = word3.replace("\u00e9\u00ed", "ei");
                    word3 = word3.replace("\u00e9\u00fa", "eu");
                    word3 = word3.replace("\u00ed\u00e9", "ie");
                    word3 = word3.replace("\u00f3\u00e9", "oe");
                    word3 = word3.replace("\u00f3\u00ed", "oi");
                    word3 = word3.replace("\u00f3\u00f3", "oo");
                    word3 = word3.replace("\u00f3\u00fa", "ou");
                    word3 = word3.replace("\u00fa\u00ed", "ui");
                    word3 = word3.replace("\u00fa\u00fa", "uu");
                    word3 = word3.replace("\u00edj", "ij");
                    word3 = word3.replaceAll("(^|[^aeiou])\u00e1([^aeiou]|$)", "$1a$2");
                    word3 = word3.replaceAll("(^|[^aeiou])\u00e9([^aeiou]|$)", "$1e$2");
                    word3 = word3.replaceAll("(^|[^aeiou])\u00ed([^aeiou]|$)", "$1i$2");
                    word3 = word3.replaceAll("(^|[^aeiou])\u00f3([^aeiou]|$)", "$1o$2");
                    word3 = word3.replaceAll("(^|[^aeiou])\u00fa([^aeiou]|$)", "$1u$2");
                    if (word3.equals(word2)) {
                        ignoreSpelling = true;
                    }
                }
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            if (ignoreSpelling) {
                atr.ignoreSpelling();
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

