/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.rules.AbstractWordCoherencyRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordCoherencyDataLoader;

public class WordCoherencyRule
extends AbstractWordCoherencyRule {
    private static final Map<String, Set<String>> wordMap = new WordCoherencyDataLoader().loadWords("/nl/coherency.txt");

    public WordCoherencyRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.addExamplePair(Example.wrong((String)"We raden af om in \u00e9\u00e9n tekst zowel <marker>hivtest</marker> als <marker>hiv-test</marker> te schrijven."), Example.fixed((String)"We raden af om in \u00e9\u00e9n tekst zowel <marker>hivtest</marker> als <marker>hivtest</marker> te schrijven."));
    }

    protected Map<String, Set<String>> getWordMap() {
        return wordMap;
    }

    protected String getMessage(String word1, String word2) {
        return "Gebruik liever geen verschillende spellingen ('" + word1 + "' en '" + word2 + "') door elkaar in een tekst.";
    }

    public String getId() {
        return "NL_WORD_COHERENCY";
    }

    public String getDescription() {
        return "Consistente spelling van woorden met meerdere correcte vormen.";
    }
}

