/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.nl.CompoundRule;
import org.languagetool.rules.nl.DutchConfusionProbabilityRule;
import org.languagetool.rules.nl.DutchWrongWordInContextRule;
import org.languagetool.rules.nl.MorfologikDutchSpellerRule;
import org.languagetool.rules.nl.PreferredWordRule;
import org.languagetool.rules.nl.SimpleReplaceRule;
import org.languagetool.rules.nl.WordCoherencyRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.nl.DutchSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.nl.DutchTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.nl.DutchWordTokenizer;

public class Dutch
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private Tokenizer wordTokenizer;
    private LanguageModel languageModel;

    public String getName() {
        return "Dutch";
    }

    public String getShortCode() {
        return "nl";
    }

    public String[] getCountries() {
        return new String[]{"NL", "BE"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new DutchTagger();
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new DutchSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new DutchWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new XmlRuleDisambiguator((Language)new Dutch());
        }
        return this.disambiguator;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("OpenTaal", "http://www.opentaal.org"), new Contributor("TaalTik", "http://www.taaltik.nl")};
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201c", "\u2039", "\u201c", "\u201e", "\""), Arrays.asList("]", ")", "}", "\u201d", "\u203a", "\u201d", "\u201d", "\"")), new UppercaseSentenceStartRule(messages, (Language)this), new MorfologikDutchSpellerRule(messages, this, userConfig, altLanguages), new MultipleWhitespaceRule(messages, (Language)this), new CompoundRule(messages), new DutchWrongWordInContextRule(messages), new WordCoherencyRule(messages), new SimpleReplaceRule(messages), new LongSentenceRule(messages, userConfig, -1, true), new PreferredWordRule(messages), new SentenceWhitespaceRule(messages)});
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new DutchConfusionProbabilityRule(messages, languageModel, this)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel == null) {
            this.languageModel = new LuceneLanguageModel(new File(indexDir, this.getShortCode()));
        }
        return this.languageModel;
    }

    public int getPriorityForId(String id) {
        switch (id) {
            case "TOO_LONG_SENTENCE": {
                return -1;
            }
        }
        return super.getPriorityForId(id);
    }

    public List<String> getRuleFileNames() {
        List ruleFileNames = super.getRuleFileNames();
        String dirBase = JLanguageTool.getDataBroker().getRulesDir() + "/" + this.getShortCode() + "/";
        ruleFileNames.add(dirBase + "grammar-test-1.xml");
        return ruleFileNames;
    }
}

