/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.Rule;
import org.languagetool.rules.km.KhmerSimpleReplaceRule;
import org.languagetool.rules.km.KhmerSpaceBeforeRule;
import org.languagetool.rules.km.KhmerUnpairedBracketsRule;
import org.languagetool.rules.km.KhmerWordRepeatRule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.km.KhmerTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.km.KhmerWordTokenizer;

public class Khmer
extends Language {
    private Tagger tagger;
    private Tokenizer wordTokenizer;
    private SentenceTokenizer sentenceTokenizer;
    private Disambiguator disambiguator;

    public String getName() {
        return "Khmer";
    }

    public String getShortCode() {
        return "km";
    }

    public String[] getCountries() {
        return new String[]{"KH"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new KhmerTagger();
        }
        return this.tagger;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new KhmerWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new XmlRuleDisambiguator((Language)new Khmer());
        }
        return this.disambiguator;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Nathan Wells")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new HunspellRule(messages, (Language)this), new KhmerSimpleReplaceRule(messages), new KhmerWordRepeatRule(messages, this), new KhmerUnpairedBracketsRule(messages, this), new KhmerSpaceBeforeRule(messages, this)});
    }
}

