/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.km;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class KhmerWordRepeatRule
extends Rule {
    public KhmerWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
    }

    public boolean ignore(AnalyzedSentence sentence, AnalyzedTokenReadings[] tokensWithWhiteSpace, int position) {
        int origPos = sentence.getOriginalPosition(position);
        return position >= 1 && " ".equals(tokensWithWhiteSpace[origPos - 1].getToken());
    }

    public String getId() {
        return "KM_WORD_REPEAT_RULE";
    }

    public String getDescription() {
        return this.messages.getString("desc_repetition");
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        AnalyzedTokenReadings[] tokensWithWS = sentence.getTokens();
        String prevToken = "";
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            boolean isWord = this.isWord(token);
            boolean isException = this.ignore(sentence, tokensWithWS, i);
            if (isWord && prevToken.equalsIgnoreCase(token) && !isException) {
                String msg = this.messages.getString("repetition");
                int prevPos = tokens[i - 1].getStartPos();
                int pos = tokens[i].getStartPos();
                RuleMatch ruleMatch = new RuleMatch((Rule)this, prevPos, pos + prevToken.length(), msg, this.messages.getString("desc_repetition_short"));
                ArrayList<String> replacementSuggs = new ArrayList<String>();
                replacementSuggs.add(prevToken + " " + token);
                replacementSuggs.add(prevToken);
                replacementSuggs.add(prevToken + "\u17d7");
                ruleMatch.setSuggestedReplacements(replacementSuggs);
                ruleMatches.add(ruleMatch);
            }
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isWord(String token) {
        char c;
        boolean isWord = true;
        if (token.length() == 1 && !Character.isLetter(c = token.charAt(0))) {
            isWord = false;
        }
        return isWord;
    }

    public void reset() {
    }
}

