/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.spelling.hunspell.HunspellNoSuggestionRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Icelandic
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private String name = "Icelandic";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "is";
    }

    public String[] getCountries() {
        return new String[]{"IS"};
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Anton Karl Ingason")};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new DemoTagger();
        }
        return this.tagger;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) {
        return Arrays.asList(new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages), new HunspellNoSuggestionRule(messages, (Language)this), new UppercaseSentenceStartRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this));
    }
}

