/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.gl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Galician;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class GalicianWordinessRule
extends AbstractSimpleReplaceRule2 {
    public static final String GL_WORDINESS_REPLACE = "GL_WORDINESS_REPLACE";
    private static final String FILE_NAME = "/gl/wordiness.txt";
    private static final Locale GL_LOCALE = new Locale("gl");

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public GalicianWordinessRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Galician());
        super.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>Raramente \u00e9 o caso en que acontece</marker> isto."), Example.fixed((String)"<marker>Raramente acontece</marker> isto."));
    }

    public final String getId() {
        return GL_WORDINESS_REPLACE;
    }

    public String getDescription() {
        return "2. Expresi\u00f3ns prolixas";
    }

    public String getShort() {
        return "Expresi\u00f3n prolixa";
    }

    public String getSuggestion() {
        return "'$match' \u00e9 unha expresi\u00f3n innecesariamente complexa. \u00c9 prefer\u00edbel dicir $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public Locale getLocale() {
        return GL_LOCALE;
    }
}

