/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ga;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.ga.Retaggable;
import org.languagetool.tagging.ga.Utils;
import org.languagetool.tools.StringTools;

public class IrishTagger
extends BaseTagger {
    public IrishTagger() {
        super("/ga/irish.dict", new Locale("ga"));
    }

    public final List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = Utils.toLowerCaseIrish(word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
            List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
            boolean isLowercase = word.equals(lowerWord);
            this.addTokens(taggerTokens, l);
            if (!isLowercase) {
                this.addTokens(lowerTaggerTokens, l);
            }
            if (lowerTaggerTokens.isEmpty() && taggerTokens.isEmpty()) {
                List guessedTokens = this.asAnalyzedTokenListForTaggedWords(word, this.filterMorph(word));
                List lowerGuessedTokens = this.asAnalyzedTokenListForTaggedWords(word, this.filterMorph(Utils.toLowerCaseIrish(word)));
                if (!guessedTokens.isEmpty()) {
                    this.addTokens(guessedTokens, l);
                }
                if (guessedTokens.isEmpty() && !lowerGuessedTokens.isEmpty()) {
                    this.addTokens(lowerGuessedTokens, l);
                }
                if (isLowercase) {
                    List upperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(StringTools.uppercaseFirstChar((String)word)));
                    if (!upperTaggerTokens.isEmpty()) {
                        this.addTokens(upperTaggerTokens, l);
                    } else {
                        List upperGuessedTokens = this.asAnalyzedTokenListForTaggedWords(word, this.filterMorph(StringTools.uppercaseFirstChar((String)word)));
                        if (!upperGuessedTokens.isEmpty()) {
                            this.addTokens(upperGuessedTokens, l);
                        } else {
                            l.add(new AnalyzedToken(word, null, null));
                        }
                    }
                } else {
                    l.add(new AnalyzedToken(word, null, null));
                }
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    private List<TaggedWord> filterMorph(String in) {
        ArrayList<TaggedWord> tagged = new ArrayList<TaggedWord>();
        List<Retaggable> tocheck = Utils.morphWord(in);
        if (tocheck.isEmpty()) {
            return tagged;
        }
        for (Retaggable rt : tocheck) {
            boolean pfx = false;
            List cur = this.getWordTagger().tag(rt.getWord());
            if (rt.getPrefix() != null && !rt.getPrefix().equals("")) {
                pfx = true;
                String tryword = rt.getPrefix() + Utils.lenite(rt.getWord());
                List joined = this.getWordTagger().tag(tryword);
                String hyphword = rt.getPrefix() + "-" + Utils.lenite(rt.getWord());
                List hyphen = this.getWordTagger().tag(hyphword);
                if (!joined.isEmpty()) {
                    cur = joined;
                    pfx = false;
                } else if (!hyphen.isEmpty()) {
                    pfx = false;
                    cur = hyphen;
                } else {
                    pfx = true;
                }
            }
            if (cur.isEmpty()) continue;
            for (TaggedWord tw : cur) {
                Object append;
                Object object = append = pfx ? rt.getAppendTag() + ":NonStdCmpd" : rt.getAppendTag();
                if (!tw.getPosTag().matches(rt.getRestrictToPos())) continue;
                String lemma = pfx ? rt.getPrefix() + Utils.lenite(tw.getLemma()) : tw.getLemma();
                tagged.add(new TaggedWord(lemma, tw.getPosTag() + (String)append));
            }
        }
        return tagged;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

