/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.LanguageWithModel;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.ga.CompoundRule;
import org.languagetool.rules.ga.DativePluralStandardReplaceRule;
import org.languagetool.rules.ga.DhaNoBeirtRule;
import org.languagetool.rules.ga.EnglishHomophoneRule;
import org.languagetool.rules.ga.IrishFGBEqReplaceRule;
import org.languagetool.rules.ga.IrishReplaceRule;
import org.languagetool.rules.ga.IrishSpecificCaseRule;
import org.languagetool.rules.ga.LogainmRule;
import org.languagetool.rules.ga.MorfologikIrishSpellerRule;
import org.languagetool.rules.ga.PeopleRule;
import org.languagetool.rules.ga.PrestandardReplaceRule;
import org.languagetool.rules.ga.SpacesRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ga.IrishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ga.IrishHybridDisambiguator;
import org.languagetool.tagging.ga.IrishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;

public class Irish
extends LanguageWithModel {
    private static final String LANGUAGE_SHORT_CODE = "ga";
    private static volatile Throwable instantiationTrace;

    public Irish() {
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    public String getName() {
        return "Irish";
    }

    public String[] getCountries() {
        return new String[]{"IE"};
    }

    public String getShortCode() {
        return LANGUAGE_SHORT_CODE;
    }

    @NotNull
    public Language getDefaultLanguageVariant() {
        return Irish.getInstance();
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jim O'Regan"), new Contributor("Emily Barnes"), new Contributor("M\u00edche\u00e1l J. \u00d3 Meachair"), new Contributor("Sean\u00e1n \u00d3 Coist\u00edn")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\"", "\u201c"), Arrays.asList("]", ")", "}", "\"", "\u201d")), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this), new LongSentenceRule(messages, userConfig, 50), new LongParagraphRule(messages, (Language)this, userConfig), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new ParagraphRepeatBeginningRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this), new MorfologikIrishSpellerRule(messages, (Language)this, userConfig, altLanguages), new LogainmRule(messages, (Language)this), new PeopleRule(messages, (Language)this), new SpacesRule(messages, (Language)this), new CompoundRule(messages, (Language)this, userConfig), new PrestandardReplaceRule(messages, (Language)this), new IrishReplaceRule(messages, (Language)this), new IrishFGBEqReplaceRule(messages, (Language)this), new EnglishHomophoneRule(messages, (Language)this), new DhaNoBeirtRule(messages), new DativePluralStandardReplaceRule(messages, (Language)this), new IrishSpecificCaseRule(messages)});
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new IrishTagger();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return IrishSynthesizer.INSTANCE;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Disambiguator createDefaultDisambiguator() {
        return new IrishHybridDisambiguator();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new WordTokenizer();
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
        }
        return super.getPriorityForId(id);
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikIrishSpellerRule(messages, (Language)this, null, null);
    }

    @NotNull
    public static Irish getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof Irish) {
            Irish irish = (Irish)language;
            return irish;
        }
        throw new RuntimeException("Irish language expected, got " + language);
    }
}

