/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ga;

import java.util.Objects;

public class Retaggable {
    private String word;
    private String restrictToPos;
    private String appendTag;
    private String prefix;

    Retaggable(String word, String restrictToPos, String appendTag) {
        this.word = Objects.requireNonNull(word, "word must not be null");
        this.restrictToPos = restrictToPos;
        this.appendTag = appendTag;
    }

    Retaggable(String word, String restrictToPos, String appendTag, String prefix) {
        this(word, restrictToPos, appendTag);
        this.prefix = prefix;
    }

    void setAppendTag(String appendTag) {
        this.appendTag = this.appendTag == null || "".equals(this.appendTag) ? appendTag : this.appendTag + appendTag;
    }

    void setRestrictToPos(String restrictToPos) {
        this.restrictToPos = this.restrictToPos == null || "".equals(this.restrictToPos) ? restrictToPos : this.restrictToPos + "|" + restrictToPos;
    }

    public String getWord() {
        return this.word;
    }

    public String getRestrictToPos() {
        return this.restrictToPos;
    }

    public String getAppendTag() {
        return this.appendTag;
    }

    String getPrefix() {
        return this.prefix;
    }
}

