/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class PrestandardReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = PrestandardReplaceRule.loadFromPath((String)"/ga/replace-prestandard.txt");
    private static final Locale GA_LOCALE = new Locale("GA");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public PrestandardReplaceRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"\u201cN\u00ed <marker>baoghal</marker> daoibh,\u201d ar sise."), Example.fixed((String)"\u201cN\u00ed <marker>baol</marker> daoibh,\u201d ar sise."));
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "GA_PRESTANDARD_REPLACE";
    }

    public String getDescription() {
        return "Litri\u00fa r\u00e9amhchaighde\u00e1nach, m.sh., \"baoghal\" in \u00e1it \"baol\"";
    }

    public String getShort() {
        return "Litri\u00fa r\u00e9amhchaighde\u00e1nach";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Litri\u00fa r\u00e9amhchaighde\u00e1nach:\"" + String.join((CharSequence)", ", replacements) + "\".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return GA_LOCALE;
    }
}

