/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class IrishReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = IrishReplaceRule.loadFromPath((String)"/ga/replace.txt");
    private static final Locale GA_LOCALE = new Locale("GA");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public IrishReplaceRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"N\u00edl beann agam oraibh, ar <marker>bh\u00far</marker> gcuid cainte."), Example.fixed((String)"N\u00edl beann agam oraibh, ar <marker>bhur</marker> gcuid cainte."));
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "GA_REPLACE";
    }

    public String getDescription() {
        return "Litri\u00fa m\u00edcheart, m.sh., \"agsu\" in \u00e1it \"agus\"";
    }

    public String getShort() {
        return "Litri\u00fa m\u00edcheart";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Litri\u00fa m\u00edcheart: \"" + String.join((CharSequence)", ", replacements) + "\".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return GA_LOCALE;
    }
}

