/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class EnglishHomophoneRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = EnglishHomophoneRule.loadFromPath((String)"/ga/english-homophones.txt");
    private static final Locale GA_LOCALE = new Locale("GA");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public EnglishHomophoneRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"An bhialann <marker>sushi</marker> sin ba ch\u00fais leis."), Example.fixed((String)"An bhialann <marker>s\u00fais\u00ed</marker> sin ba ch\u00fais leis."));
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "GA_ENGLISH_HOMOPHONE";
    }

    public String getDescription() {
        return "Is homaf\u00f3in iad na focail, m.sh., \"well\" agus \"bhuel\"";
    }

    public String getShort() {
        return "Homaf\u00f3n B\u00e9arla.";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Is \u00e9 " + String.join((CharSequence)", ", replacements) + " an litri\u00fa Gaelach ar \"" + tokenStr + "\"";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return GA_LOCALE;
    }
}

