/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.ga.DativePluralsData;

public class DativePluralStandardReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, String> replacements = DativePluralsData.getSimpleReplacements();
    private static final Map<String, List<String>> wrongWords = DativePluralStandardReplaceRule.listify(replacements);
    private static final Locale GA_LOCALE = new Locale("GA");

    private static Map<String, List<String>> listify(Map<String, String> singles) {
        HashMap<String, List<String>> out = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> e : singles.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(e.getValue());
            out.put(e.getKey(), tmp);
        }
        return out;
    }

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public DativePluralStandardReplaceRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Grammar);
        this.addExamplePair(Example.wrong((String)"D\u00e1 mba thruamh\u00e9alach \u00e9 c\u00e1s an scl\u00e1bha\u00ed fir, ba mheasa f\u00f3s do na <marker>mn\u00e1ibh</marker> a gc\u00e1s si\u00fad."), Example.fixed((String)"D\u00e1 mba thruamh\u00e9alach \u00e9 c\u00e1s an scl\u00e1bha\u00ed fir, ba mheasa f\u00f3s do na <marker>mn\u00e1</marker> a gc\u00e1s si\u00fad."));
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "GA_DATIVE_PLURALS_STD";
    }

    public String getDescription() {
        return "Tuiseal tabharthach iolra";
    }

    public String getShort() {
        return "Tabharthach iolra";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Is litri\u00fa r\u00e9amhchaighde\u00e1nach (tabharthach iolra) \u00e9 \"" + tokenStr + "\"; an \"" + String.join((CharSequence)", ", replacements) + "\" a bh\u00ed i gceist agat?";
    }
}

