/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tagging.ga.Utils;

public final class MorfologikIrishSpellerRule
extends MorfologikSpellerRule {
    private static final String RESOURCE_FILENAME = "/ga/hunspell/ga_IE.dict";
    private static final Pattern IRISH_TOKENIZING_CHARS = Pattern.compile("-");

    public MorfologikIrishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.ignoreWordsWithLength = 1;
        this.setCategory(Categories.TYPOS.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"T\u00e1 <marker>botun</marker> san abairt seo."), Example.fixed((String)"T\u00e1 <marker>bot\u00fan</marker> san abairt seo."));
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_GA_IE";
    }

    public Pattern tokenizingPattern() {
        return IRISH_TOKENIZING_CHARS;
    }

    public boolean isMisspelled(String word) throws IOException {
        String checkWord = word;
        if (Utils.isAllMathsChars(word)) {
            checkWord = Utils.simplifyMathematical(word);
        } else if (Utils.isAllHalfWidthChars(word)) {
            checkWord = Utils.halfwidthLatinToLatin(word);
        }
        return super.isMisspelled(checkWord);
    }
}

