/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ga.DhaNoBeirtData;

public class DhaNoBeirtRule
extends Rule {
    public DhaNoBeirtRule(ResourceBundle messages) {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"T\u00e1 <marker>dh\u00e1</marker> dhearth\u00e1ireacha agam."), Example.fixed((String)"T\u00e1 <marker>beirt</marker> dhearth\u00e1ireacha agam."));
    }

    public String getId() {
        return "GA_DHA_NO_BEIRT";
    }

    public String getDescription() {
        return "'dh\u00e1' n\u00f3 'beirt'";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        int markDeag = 1;
        int prevTokenIndex = 0;
        String replacement = null;
        String msg = null;
        int i = 1;
        while (i < tokens.length) {
            if (this.isNumber(tokens[i]) && i < tokens.length - 2 && this.isPerson(tokens[i + 1])) {
                if ("dh\u00e1".equalsIgnoreCase(tokens[i].getToken()) && i < tokens.length - 2) {
                    for (int j = i + 2; j < tokens.length; ++j) {
                        if (!"d\u00e9ag".equalsIgnoreCase(tokens[j].getToken())) continue;
                        markDeag = j;
                        replacement = "dh\u00e1r\u00e9ag";
                        msg = "Ba ch\u00f3ir duit <suggestion>" + replacement + "</suggestion> a scr\u00edobh";
                        RuleMatch match = new RuleMatch((Rule)this, sentence, tokens[prevTokenIndex + 1].getStartPos(), tokens[prevTokenIndex + 1].getEndPos(), msg, "Uimhir phearsanta");
                        ruleMatches.add(match);
                        msg = "Ba ch\u00f3ir duit \"d\u00e9ag\" a scriosadh.";
                        RuleMatch match2 = new RuleMatch((Rule)this, sentence, tokens[markDeag].getStartPos(), tokens[markDeag].getEndPos(), msg, "Uimhir phearsanta");
                        ruleMatches.add(match2);
                        msg = null;
                    }
                }
                if (replacement == null) {
                    replacement = DhaNoBeirtData.getNumberReplacements().get(tokens[i].getToken());
                    if (msg == null) {
                        msg = "Ba ch\u00f3ir duit <suggestion>" + replacement + " " + tokens[i + 1].getToken() + "</suggestion> a scr\u00edobh";
                    }
                }
            }
            if (msg != null) {
                RuleMatch match = new RuleMatch((Rule)this, sentence, tokens[prevTokenIndex + 1].getStartPos(), tokens[prevTokenIndex + 1].getEndPos(), msg, "Uimhir phearsanta");
                ruleMatches.add(match);
                msg = null;
            }
            prevTokenIndex = i++;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isNumber(AnalyzedTokenReadings tok) {
        for (String num : DhaNoBeirtData.getNumberReplacements().keySet()) {
            if (!num.equalsIgnoreCase(tok.getToken())) continue;
            return true;
        }
        return false;
    }

    private boolean isPerson(AnalyzedTokenReadings tok) {
        if (DhaNoBeirtData.getDaoine().contains(tok.getToken().toLowerCase())) {
            return true;
        }
        for (AnalyzedToken reading : tok.getReadings()) {
            if (!DhaNoBeirtData.getDaoine().contains(reading.getLemma())) continue;
            return true;
        }
        return false;
    }
}

