/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class LogainmRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = LogainmRule.loadFromPath((String)"/ga/placenames.txt");
    private static final Locale GA_LOCALE = new Locale("GA");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public LogainmRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setIgnoreTaggedWords();
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "GA_LOGAINM";
    }

    public String getDescription() {
        return "Logainm B\u00e9arla, m.sh., 'Dublin' in \u00e1it 'Baile \u00c1tha Cliath'.";
    }

    public String getShort() {
        return "Logainm B\u00e9arla";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Is logainm B\u00e9arla \u00e9 \"" + tokenStr + "\" ar \"" + String.join((CharSequence)", ", replacements) + "\".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://www.logainm.ie/ga/");
    }

    public Locale getLocale() {
        return GA_LOCALE;
    }
}

