/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.ga.CompoundRule;
import org.languagetool.rules.ga.DativePluralStandardReplaceRule;
import org.languagetool.rules.ga.DhaNoBeirtRule;
import org.languagetool.rules.ga.EnglishHomophoneRule;
import org.languagetool.rules.ga.IrishFGBEqReplaceRule;
import org.languagetool.rules.ga.IrishReplaceRule;
import org.languagetool.rules.ga.IrishSpecificCaseRule;
import org.languagetool.rules.ga.LogainmRule;
import org.languagetool.rules.ga.MorfologikIrishSpellerRule;
import org.languagetool.rules.ga.PeopleRule;
import org.languagetool.rules.ga.PrestandardReplaceRule;
import org.languagetool.rules.ga.SpacesRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ga.IrishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ga.IrishHybridDisambiguator;
import org.languagetool.tagging.ga.IrishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;

public class Irish
extends Language
implements AutoCloseable {
    private static final Language DEFAULT_IRISH = new Irish();
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private LanguageModel languageModel;

    public String getName() {
        return "Irish";
    }

    public String[] getCountries() {
        return new String[]{"IE"};
    }

    public String getShortCode() {
        return "ga";
    }

    public Language getDefaultLanguageVariant() {
        return DEFAULT_IRISH;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jim O'Regan"), new Contributor("Emily Barnes"), new Contributor("M\u00edche\u00e1l J. \u00d3 Meachair"), new Contributor("Sean\u00e1n \u00d3 Coist\u00edn")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\"", "\u201c"), Arrays.asList("]", ")", "}", "\"", "\u201d")), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this), new LongSentenceRule(messages, userConfig, -1, true), new LongParagraphRule(messages, (Language)this, userConfig), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new ParagraphRepeatBeginningRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this), new MorfologikIrishSpellerRule(messages, this, userConfig, altLanguages), new LogainmRule(messages), new PeopleRule(messages), new SpacesRule(messages), new CompoundRule(messages), new PrestandardReplaceRule(messages), new IrishReplaceRule(messages), new IrishFGBEqReplaceRule(messages), new EnglishHomophoneRule(messages), new DhaNoBeirtRule(messages), new DativePluralStandardReplaceRule(messages), new IrishSpecificCaseRule(messages)});
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new IrishTagger();
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new IrishSynthesizer(this);
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new IrishHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new WordTokenizer();
        }
        return this.wordTokenizer;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }
}

