/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.LanguageWithModel;
import org.languagetool.Languages;
import org.languagetool.ResourceBundleTools;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.fr.CompoundRule;
import org.languagetool.rules.fr.FrenchConfusionProbabilityRule;
import org.languagetool.rules.fr.FrenchMultitokenSpeller;
import org.languagetool.rules.fr.FrenchRepeatedWordsRule;
import org.languagetool.rules.fr.GrammalecteRule;
import org.languagetool.rules.fr.MorfologikFrenchSpellerRule;
import org.languagetool.rules.fr.QuestionWhitespaceRule;
import org.languagetool.rules.fr.QuestionWhitespaceStrictRule;
import org.languagetool.rules.fr.SimpleReplaceRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.multitoken.MultitokenSpeller;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.fr.FrenchHybridDisambiguator;
import org.languagetool.tagging.fr.FrenchTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.fr.FrenchWordTokenizer;

public class French
extends LanguageWithModel {
    private static final String BEFORE_APOS = "([cjnmtsldCJNMTSLD]|qu|jusqu|lorsqu|puisqu|quoiqu|Qu|Jusqu|Lorsqu|Puisqu|Quoiqu|QU|JUSQU|LORSQU|PUISQU|QUOIQU)";
    private static final Pattern BEFORE_APOS_PATTERN_1 = Pattern.compile("(\\b([cjnmtsldCJNMTSLD]|qu|jusqu|lorsqu|puisqu|quoiqu|Qu|Jusqu|Lorsqu|Puisqu|Quoiqu|QU|JUSQU|LORSQU|PUISQU|QUOIQU))'");
    private static final Pattern BEFORE_APOS_PATTERN_2 = Pattern.compile("(\\b([cjnmtsldCJNMTSLD]|qu|jusqu|lorsqu|puisqu|quoiqu|Qu|Jusqu|Lorsqu|Puisqu|Quoiqu|QU|JUSQU|LORSQU|PUISQU|QUOIQU))\u2019\"");
    private static final Pattern BEFORE_APOS_PATTERN_3 = Pattern.compile("(\\b([cjnmtsldCJNMTSLD]|qu|jusqu|lorsqu|puisqu|quoiqu|Qu|Jusqu|Lorsqu|Puisqu|Quoiqu|QU|JUSQU|LORSQU|PUISQU|QUOIQU))\u2019'");
    private static final Pattern TYPOGRAPHY_PATTERN_1 = Pattern.compile("\u00a0;");
    private static final Pattern TYPOGRAPHY_PATTERN_2 = Pattern.compile("\u00a0!");
    private static final Pattern TYPOGRAPHY_PATTERN_3 = Pattern.compile("\u00a0\\?");
    private static final Pattern TYPOGRAPHY_PATTERN_4 = Pattern.compile(";");
    private static final Pattern TYPOGRAPHY_PATTERN_5 = Pattern.compile("!");
    private static final Pattern TYPOGRAPHY_PATTERN_6 = Pattern.compile("\\?");
    private static final Pattern TYPOGRAPHY_PATTERN_7 = Pattern.compile(":");
    private static final Pattern TYPOGRAPHY_PATTERN_8 = Pattern.compile("\u00bb");
    private static final Pattern TYPOGRAPHY_PATTERN_9 = Pattern.compile("\u00ab");
    private static final Pattern TYPOGRAPHY_PATTERN_10 = Pattern.compile("\u00a0\u00a0");
    private static final Pattern TYPOGRAPHY_PATTERN_11 = Pattern.compile("\u202f\u202f");
    private static final Pattern TYPOGRAPHY_PATTERN_12 = Pattern.compile("  ");
    private static final Pattern TYPOGRAPHY_PATTERN_13 = Pattern.compile("\u00a0 ");
    private static final Pattern TYPOGRAPHY_PATTERN_14 = Pattern.compile(" \u00a0");
    private static final Pattern TYPOGRAPHY_PATTERN_15 = Pattern.compile(" \u202f");
    private static final Pattern TYPOGRAPHY_PATTERN_16 = Pattern.compile("\u202f ");
    private static final String FRENCH_SHORT_CODE = "fr";
    private static volatile Throwable instantiationTrace;
    private static final Map<String, Integer> id2prio;
    private final List<String> spellerExceptions = Collections.singletonList("Ho Chi Minh");

    @Deprecated
    public French() {
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected French(boolean fakeValue) {
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public String getName() {
        return "French";
    }

    public String getShortCode() {
        return FRENCH_SHORT_CODE;
    }

    public String[] getCountries() {
        return new String[]{"FR", "", "LU", "MC", "CM", "CI", "HT", "ML", "SN", "CD", "MA", "RE"};
    }

    public Language getDefaultLanguageVariant() {
        return Languages.getLanguageForShortCode((String)FRENCH_SHORT_CODE);
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return FrenchTagger.INSTANCE;
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return FrenchSynthesizer.INSTANCE;
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new FrenchWordTokenizer();
    }

    public Disambiguator createDefaultDisambiguator() {
        return new FrenchHybridDisambiguator();
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.DOMINIQUE_PELLE};
    }

    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikFrenchSpellerRule(messages, (Language)this, null, Collections.emptyList());
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, false), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{"), Arrays.asList("]", ")", "}")), userConfig == null && altLanguages.isEmpty() ? this.getDefaultSpellingRule() : new MorfologikFrenchSpellerRule(messages, (Language)this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new LongSentenceRule(messages, userConfig, 40), new LongParagraphRule(messages, (Language)this, userConfig), new CompoundRule(messages, (Language)this, userConfig), new QuestionWhitespaceStrictRule(messages, (Language)this), new QuestionWhitespaceRule(messages, (Language)this), new SimpleReplaceRule(messages, (Language)this), new FrenchRepeatedWordsRule(messages)});
    }

    public List<Rule> getRelevantRulesGlobalConfig(ResourceBundle messages, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (globalConfig != null && globalConfig.getGrammalecteServer() != null) {
            rules.add(new GrammalecteRule(messages, globalConfig));
        }
        return rules;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Collections.singletonList(new FrenchConfusionProbabilityRule(messages, languageModel, (Language)this));
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public String toAdvancedTypography(String input) {
        String output = super.toAdvancedTypography(input);
        output = BEFORE_APOS_PATTERN_1.matcher(output).replaceAll("$1\u2019");
        output = BEFORE_APOS_PATTERN_2.matcher(output).replaceAll("$1\u2019" + this.getOpeningDoubleQuote());
        output = BEFORE_APOS_PATTERN_3.matcher(output).replaceAll("$1\u2019" + this.getOpeningSingleQuote());
        output = TYPOGRAPHY_PATTERN_1.matcher(output).replaceAll("\u202f;");
        output = TYPOGRAPHY_PATTERN_2.matcher(output).replaceAll("\u202f!");
        output = TYPOGRAPHY_PATTERN_3.matcher(output).replaceAll("\u202f?");
        output = TYPOGRAPHY_PATTERN_4.matcher(output).replaceAll("\u202f;");
        output = TYPOGRAPHY_PATTERN_5.matcher(output).replaceAll("\u202f!");
        output = TYPOGRAPHY_PATTERN_6.matcher(output).replaceAll("\u202f?");
        output = TYPOGRAPHY_PATTERN_7.matcher(output).replaceAll("\u00a0:");
        output = TYPOGRAPHY_PATTERN_8.matcher(output).replaceAll("\u00a0\u00bb");
        output = TYPOGRAPHY_PATTERN_9.matcher(output).replaceAll("\u00ab\u00a0");
        output = TYPOGRAPHY_PATTERN_10.matcher(output).replaceAll("\u00a0");
        output = TYPOGRAPHY_PATTERN_11.matcher(output).replaceAll("\u202f");
        output = TYPOGRAPHY_PATTERN_12.matcher(output).replaceAll(" ");
        output = TYPOGRAPHY_PATTERN_13.matcher(output).replaceAll("\u00a0");
        output = TYPOGRAPHY_PATTERN_14.matcher(output).replaceAll("\u00a0");
        output = TYPOGRAPHY_PATTERN_15.matcher(output).replaceAll("\u202f");
        output = TYPOGRAPHY_PATTERN_16.matcher(output).replaceAll("\u202f");
        return output;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public Map<String, Integer> getPriorityMap() {
        return id2prio;
    }

    protected int getPriorityForId(String id) {
        Integer prio = id2prio.get(id);
        if (prio != null) {
            return prio;
        }
        if (id.startsWith("FR_COMPOUNDS")) {
            return 500;
        }
        if (id.equals("CAT_TYPOGRAPHIE")) {
            return 20;
        }
        if (id.equals("CAT_TOURS_CRITIQUES")) {
            return 20;
        }
        if (id.equals("CAT_HOMONYMES_PARONYMES")) {
            return 20;
        }
        if (id.equals("SON")) {
            return -5;
        }
        if (id.startsWith("CAR")) {
            return -50;
        }
        if (id.equals("CONFUSION_RULE_PREMIUM")) {
            return -50;
        }
        if (id.startsWith("FR_MULTITOKEN_SPELLING_")) {
            return -90;
        }
        if (id.startsWith("FR_SIMPLE_REPLACE")) {
            return 150;
        }
        if (id.startsWith("grammalecte_")) {
            return -150;
        }
        if (id.startsWith("AI_FR_HYDRA_LEO")) {
            return -101;
        }
        if (id.startsWith("AI_FR_GGEC_REPLACEMENT_ORTHOGRAPHY")) {
            return -101;
        }
        return super.getPriorityForId(id);
    }

    public boolean hasMinMatchesRules() {
        return true;
    }

    public List<RuleMatch> filterRuleMatches(List<RuleMatch> ruleMatches, AnnotatedText text, Set<String> enabledRules) {
        ArrayList<RuleMatch> resultMatches = new ArrayList<RuleMatch>();
        RuleMatch previousMatch = null;
        for (int i = 0; i < ruleMatches.size(); ++i) {
            RuleMatch currentMatch = this.adjustFrenchRuleMatch(ruleMatches.get(i), enabledRules);
            List suggestions = currentMatch.getSuggestedReplacements();
            if (suggestions.size() == 1 && currentMatch.getRule().getId().startsWith("AI_FR_GGEC")) {
                String suggestion = (String)suggestions.get(0);
                if (currentMatch.getRule().getId().equals("AI_FR_GGEC_MISSING_PUNCTUATION_PERIOD") && suggestion.endsWith(".") && currentMatch.getSentence().getText().replaceAll("\\s+$", "").endsWith(suggestion.substring(0, suggestion.length() - 1))) continue;
            }
            if (previousMatch != null && previousMatch.getRule().getId().startsWith("AI_FR_GGEC") && currentMatch.getRule().getId().startsWith("AI_FR_GGEC")) {
                if (previousMatch.getToPos() > currentMatch.getFromPos()) continue;
                if ((previousMatch.getToPos() == currentMatch.getFromPos() || previousMatch.getToPos() + 1 == currentMatch.getFromPos()) && previousMatch.getRule().getTags().contains(Tag.picky) == currentMatch.getRule().getTags().contains(Tag.picky)) {
                    RuleMatch mergedMatch;
                    if (previousMatch.getRule().getLocQualityIssueType() == currentMatch.getRule().getLocQualityIssueType()) {
                        previousMatch = mergedMatch = new RuleMatch(this.mergeMatches(previousMatch, currentMatch));
                        continue;
                    }
                    if (previousMatch.getRule().getLocQualityIssueType() != currentMatch.getRule().getLocQualityIssueType() && previousMatch.getRule().getLocQualityIssueType() != ITSIssueType.Style && currentMatch.getRule().getLocQualityIssueType() != ITSIssueType.Style) {
                        previousMatch = mergedMatch = new RuleMatch(this.mergeMatches(previousMatch, currentMatch));
                        continue;
                    }
                }
                resultMatches.add(previousMatch);
                previousMatch = currentMatch;
                continue;
            }
            if (previousMatch != null) {
                resultMatches.add(previousMatch);
            }
            previousMatch = currentMatch;
        }
        if (previousMatch != null) {
            resultMatches.add(previousMatch);
        }
        return resultMatches;
    }

    private RuleMatch mergeMatches(RuleMatch match1, RuleMatch match2) {
        String separator = "";
        if (match1.getToPos() + 1 == match2.getFromPos()) {
            separator = " ";
        }
        String newErrorStr = match1.getOriginalErrorStr() + separator + match2.getOriginalErrorStr();
        String newReplacement = (String)match1.getSuggestedReplacements().get(0) + separator + (String)match2.getSuggestedReplacements().get(0);
        RuleMatch mergedMatch = new RuleMatch(match1.getRule(), match1.getSentence(), match1.getFromPos(), match2.getToPos(), "Il pourrait y avoir un probl\u00e8me ici.", "Erreur potentielle");
        mergedMatch.setOriginalErrorStr(newErrorStr);
        mergedMatch.setSuggestedReplacement(newReplacement);
        Object newId = "AI_FR_MERGED_MATCH";
        if (match1.getRule().getLocQualityIssueType().equals((Object)ITSIssueType.Style) && match2.getRule().getLocQualityIssueType().equals((Object)ITSIssueType.Style)) {
            newId = (String)newId + "_STYLE";
        }
        if (match1.getRule().getTags().contains(Tag.picky) && match2.getRule().getTags().contains(Tag.picky)) {
            newId = (String)newId + "_PICKY";
        }
        mergedMatch.setSpecificRuleId((String)newId);
        if (!match1.getRule().getLocQualityIssueType().equals((Object)match2.getRule().getLocQualityIssueType())) {
            mergedMatch.getRule().setLocQualityIssueType(ITSIssueType.Grammar);
        } else if (match1.getRule().getLocQualityIssueType() == ITSIssueType.Style) {
            mergedMatch.getRule().setLocQualityIssueType(ITSIssueType.Style);
        }
        return mergedMatch;
    }

    public List<String> prepareLineForSpeller(String line) {
        String[] parts = line.split("#");
        if (parts.length == 0) {
            return Collections.singletonList(line);
        }
        String[] formTag = parts[0].split("[\t;]");
        String form = formTag[0].trim();
        if (this.spellerExceptions.contains(form)) {
            return Collections.singletonList("");
        }
        if (formTag.length > 1) {
            String tag = formTag[1].trim();
            if (tag.startsWith("Z") || tag.startsWith("N") || tag.equals("A")) {
                return Collections.singletonList(form);
            }
            return Collections.singletonList("");
        }
        return Collections.singletonList(line);
    }

    public MultitokenSpeller getMultitokenSpeller() {
        return FrenchMultitokenSpeller.INSTANCE;
    }

    public RuleMatch adjustFrenchRuleMatch(RuleMatch rm, Set<String> enabledRules) {
        String suggestion;
        rm.setOriginalErrorStr();
        String errorStr = rm.getOriginalErrorStr();
        List suggestions = rm.getSuggestedReplacements();
        if (suggestions.size() == 1 && rm.getRule().getId().startsWith("AI_FR_GGEC") && (suggestion = (String)suggestions.get(0)).equalsIgnoreCase(errorStr)) {
            rm.setMessage("Un usage diff\u00e9rent des majuscules et des minuscules est recommand\u00e9.");
            rm.setShortMessage("Majuscules et minuscules");
            rm.getRule().setLocQualityIssueType(ITSIssueType.Typographical);
            rm.getRule().setCategory(Categories.CASING.getCategory(ResourceBundleTools.getMessageBundle((Language)this)));
            rm.setSpecificRuleId(rm.getRule().getId().replace("ORTHOGRAPHY", "CASING"));
        }
        if (suggestions.size() == 1 && rm.getRule().getId().startsWith("AI_FR_GGEC") && rm.getRule().getId().contains("MISSING_PRONOUN_LAPOSTROPHE") && errorStr.equals("on") && ((String)suggestions.get(0)).equals("l'on") && rm.getSentence().getText().toLowerCase().contains("si on")) {
            rm.setSpecificRuleId("AI_FR_GGEC_SI_LON");
            rm.getRule().setTags(Collections.singletonList(Tag.picky));
        }
        if (rm.getRule().getId().startsWith("AI_FR_GGEC") && rm.getRule().getId().contains("REPLACEMENT_PUNCTUATION_QUOTE")) {
            rm.setSpecificRuleId("AI_FR_GGEC_QUOTES");
            rm.getRule().setTags(Collections.singletonList(Tag.picky));
            rm.getRule().setLocQualityIssueType(ITSIssueType.Typographical);
        }
        if (enabledRules != null && enabledRules.contains("APOS_TYP")) {
            ArrayList<String> newReplacements = new ArrayList<String>();
            for (String s : rm.getSuggestedReplacements()) {
                if (s.length() > 1) {
                    s = s.replace('\'', '\u2019');
                }
                newReplacements.add(s);
            }
            rm.setSuggestedReplacements(newReplacements);
        }
        return rm;
    }

    @NotNull
    public static French getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)FRENCH_SHORT_CODE));
        if (language instanceof French) {
            French french = (French)language;
            return french;
        }
        throw new RuntimeException("French(Premium) language expected, got " + language);
    }

    static {
        id2prio = new HashMap<String, Integer>();
        id2prio.put("AGREEMENT_EXCEPTIONS", 100);
        id2prio.put("EXPRESSIONS_VU", 100);
        id2prio.put("SA_CA_SE", 100);
        id2prio.put("SIL_VOUS_PLAIT", 100);
        id2prio.put("QUASI_NOM", 100);
        id2prio.put("MA", 100);
        id2prio.put("SON_SONT", 100);
        id2prio.put("JE_TES", 100);
        id2prio.put("A_INFINITIF", 100);
        id2prio.put("ON_ONT", 100);
        id2prio.put("LEURS_LEUR", 100);
        id2prio.put("DU_DU", 100);
        id2prio.put("ACCORD_CHAQUE", 100);
        id2prio.put("J_N2", 100);
        id2prio.put("CEST_A_DIRE", 100);
        id2prio.put("FAIRE_VPPA", 100);
        id2prio.put("D_N_E_OU_E", 100);
        id2prio.put("GENS_ACCORD", 100);
        id2prio.put("VIRGULE_EXPRESSIONS_FIGEES", 100);
        id2prio.put("TRAIT_UNION", 100);
        id2prio.put("PLURIEL_AL2", 100);
        id2prio.put("FR_SPLIT_WORDS_HYPHEN", 100);
        id2prio.put("PAS_DE_TRAIT_UNION", 50);
        id2prio.put("SOCIOCULTUREL", 40);
        id2prio.put("A_VERBE_INFINITIF", 20);
        id2prio.put("DE_OU_DES", 20);
        id2prio.put("EMPLOI_EMPLOIE", 20);
        id2prio.put("VOIR_VOIRE", 20);
        id2prio.put("D_VPPA", 20);
        id2prio.put("EST_CE_QUE", 20);
        id2prio.put("CONFUSION_PARLEZ_PARLER", 10);
        id2prio.put("AGREEMENT_TOUT_LE", 10);
        id2prio.put("ESPACE_UNITES", 10);
        id2prio.put("BYTES", 10);
        id2prio.put("Y_A", 10);
        id2prio.put("COTE", 10);
        id2prio.put("PEUTETRE", 10);
        id2prio.put("A_A_ACCENT", 10);
        id2prio.put("A_ACCENT_A", 10);
        id2prio.put("A_A_ACCENT2", 10);
        id2prio.put("A_ACCENT", 10);
        id2prio.put("JE_M_APPEL", 10);
        id2prio.put("ACCORD_R_PERS_VERBE", 10);
        id2prio.put("JE_SUI", 10);
        id2prio.put("R_VAVOIR_VINF", 10);
        id2prio.put("AN_EN", 10);
        id2prio.put("APOS_M", 10);
        id2prio.put("ACCORD_PLURIEL_ORDINAUX", 10);
        id2prio.put("SUJET_AUXILIAIRE", 10);
        id2prio.put("ADJ_ADJ_SENT_END", 10);
        id2prio.put("OU_PAS", 10);
        id2prio.put("PLACE_DE_LA_VIRGULE", 10);
        id2prio.put("SE_CE", -10);
        id2prio.put("PAS_DE_SOUCIS", 10);
        id2prio.put("J_N", -10);
        id2prio.put("TE_NV", -20);
        id2prio.put("TE_NV2", -10);
        id2prio.put("INTERROGATIVE_DIRECTE", -10);
        id2prio.put("V_J_A_R", -10);
        id2prio.put("TRES_TRES_ADJ", -10);
        id2prio.put("IMP_PRON", -10);
        id2prio.put("TOO_LONG_PARAGRAPH", -15);
        id2prio.put("PREP_VERBECONJUGUE", -20);
        id2prio.put("LA_LA2", -20);
        id2prio.put("FRENCH_WORD_REPEAT_RULE", -20);
        id2prio.put("PAS_DE_VERBE_APRES_POSSESSIF_DEMONSTRATIF", -20);
        id2prio.put("VIRGULE_VERBE", -20);
        id2prio.put("VERBES_FAMILIERS", -25);
        id2prio.put("VERB_PRONOUN", -50);
        id2prio.put("IL_VERBE", -50);
        id2prio.put("A_LE", -50);
        id2prio.put("ILS_VERBE", -50);
        id2prio.put("AGREEMENT_POSTPONED_ADJ", -50);
        id2prio.put("MULTI_ADJ", -50);
        id2prio.put("PARENTHESES", -50);
        id2prio.put("REP_ESSENTIEL", -50);
        id2prio.put("CONFUSION_AL_LA", -50);
        id2prio.put("LE_COVID", -60);
        id2prio.put("FR_SPELLING_RULE", -100);
        id2prio.put("VIRG_INF", -100);
        id2prio.put("ET_SENT_START", -151);
        id2prio.put("MAIS_SENT_START", -151);
        id2prio.put("EN_CE_QUI_CONCERNE", -152);
        id2prio.put("EN_MEME_TEMPS", -152);
        id2prio.put("ET_AUSSI", -152);
        id2prio.put("MAIS_AUSSI", -152);
        id2prio.put("ELISION", -200);
        id2prio.put("POINT", -200);
        id2prio.put("REPETITIONS_STYLE", -250);
        id2prio.put("POINTS_SUSPENSIONS_SPACE", -250);
        id2prio.put("UPPERCASE_SENTENCE_START", -300);
        id2prio.put("FRENCH_WHITESPACE_STRICT", -350);
        id2prio.put("TOUT_MAJUSCULES", -400);
        id2prio.put("VIRG_NON_TROUVEE", -400);
        id2prio.put("POINTS_2", -400);
        id2prio.put("MOTS_INCOMP", -400);
        id2prio.put("FRENCH_WHITESPACE", -400);
        id2prio.put("MOT_TRAIT_MOT", -400);
        id2prio.put("FRENCH_WORD_REPEAT_BEGINNING_RULE", -350);
    }
}

