/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.GlobalConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrammalecteRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(GrammalecteRule.class);
    private static final int TIMEOUT_MILLIS = 500;
    private static final long DOWN_INTERVAL_MILLISECONDS = 5000L;
    private static long lastRequestError = 0L;
    private final ObjectMapper mapper = new ObjectMapper();
    private final GlobalConfig globalConfig;
    static final Set<String> ignoreRules = new HashSet<String>(Arrays.asList("tab_fin_ligne", "apostrophe_typographique", "typo_guillemets_typographiques_doubles_ouvrants", "nbsp_avant_double_ponctuation", "typo_guillemets_typographiques_doubles_fermants", "nbsp_avant_deux_points", "nbsp_ajout_avant_double_ponctuation", "apostrophe_typographique_apr\u00e8s_t", "typo_point_coll\u00e9_\u00e0_mot_suivant", "typo_tiret_d\u00e9but_ligne", "typo_guillemets_typographiques_simples_fermants", "typo_apostrophe_incorrecte", "unit_nbsp_avant_unit\u00e9s1", "unit_nbsp_avant_unit\u00e9s2", "unit_nbsp_avant_unit\u00e9s3", "nbsp_apr\u00e8s_double_ponctuation", "typo_guillemets_typographiques_simples_ouvrants", "num_grand_nombre_avec_espaces", "num_grand_nombre_soud\u00e9", "typo_parenth\u00e8se_ouvrante_coll\u00e9e", "nbsp_apr\u00e8s_chevrons_ouvrants", "nbsp_avant_chevrons_fermants", "nbsp_avant_chevrons_fermants1", "nbsp_avant_chevrons_fermants2", "typo_points_suspension1", "typo_points_suspension2", "typo_points_suspension3", "typo_tiret_incise", "esp_avant_apr\u00e8s_tiret", "nbsp_apr\u00e8s_tiret1", "nbsp_apr\u00e8s_tiret2", "nbsp_apr\u00e8s_tiret3", "nbsp_apr\u00e8s_chevrons_fermants", "esp_m\u00e9lang\u00e9s1", "esp_m\u00e9lang\u00e9s2", "tab_d\u00e9but_ligne", "esp_milieu_ligne", "typo_ponctuation_superflue1", "esp_ins\u00e9cables_multiples", "typo_espace_manquant_apr\u00e8s1", "typo_espace_manquant_apr\u00e8s2", "typo_espace_manquant_apr\u00e8s3", "typo_tiret_incise2", "g1__bs_vid\u00e9oprotection__b1_a1_1", "g2__bs_avoir_\u00e9t\u00e9_chez__b1_a1_1", "g2__bs_pour_ne_pas_que__b1_a1_1", "g2__bs_silence_assourdissant__b1_a1_1", "g1__eleu_\u00e9lisions_manquantes__b1_a1_1", "typo_tiret_incise1", "majuscule_apr\u00e8s_point", "p_sigle2", "g0__imp_verbes_compos\u00e9s_imp\u00e9ratifs__b12_a2_1", "g0__imp_verbes_compos\u00e9s_imp\u00e9ratifs__b12_a3_1", "g0__imp_verbes_compos\u00e9s_imp\u00e9ratifs__b5_a2_1", "g2__date_journ\u00e9e_jour_mois_ann\u00e9e_", "g2__date_journ\u00e9e_jour_mois_ann\u00e9e__b1_a1_2", "g2__date_journ\u00e9e_jour_mois_ann\u00e9e__b1_a1_1", "g2__gn_tous_det_nom__b1_a2_1", "g2__gn_tous_det_nom__b2_a2_1", "g2__gn_tous_nom__b2_a1_1", "g2__gn_tout_det__b2_a1_1", "g2__gn_tout_nom__b1_a1_1", "g2__gn_tout_nom__b2_a1_1", "g2__gn_toute_nom__b1_a1_1", "g2__gn_toute_nom__b2_a1_1", "g2__gn_toutes_nom__b1_a1_1", "g2__gn_toutes_nom__b2_a1_1", "g2__gn_toutes_nom__b2_a2_1", "g3__gn_2m_et_ou__b1_a1_1", "g3__gn_2m_et_ou__b1_a2_1", "g3__gn_adverbe_fort__b1_a1_1", "g3__gn_adverbe_juste__b1_a1_1", "g3__gn_au_1m__b1_a1_1", "g3__gn_au_1m__b1_a2_1", "g3__gn_au_1m__b1_a3_1", "g3__gn_au_1m__b2_a1_1", "g3__gn_aucun_1m__b1_a1_1", "g3__gn_aucun_1m__b1_a2_1", "g3__gn_aucun_1m__b1_a3_1", "g3__gn_aucune_1m__b1_a3_1", "g3__gn_ce_1m__b1_a1_1", "g3__gn_ce_1m__b1_a2_1", "g3__gn_ce_1m__b1_a3_1", "g3__gn_ce_1m__b1_a4_1", "g3__gn_celle__b1_a2_1", "g3__gn_celles__b1_a1_1", "g3__gn_certaines_1m__b1_a2_1", "g3__gn_certaines_1m__b1_a3_1", "g3__gn_certains_1m__b1_a3_1", "g3__gn_ces_aux_pluriel_1m__b1_a1_1", "g3__gn_ces_aux_pluriel_1m__b1_a3_1", "g3__gn_ces_aux_pluriel_1m__b1_a4_1", "g3__gn_cet_1m__b1_a3_1", "g3__gn_cette_1m__b1_a1_1", "g3__gn_cette_1m__b1_a2_1", "g3__gn_cette_1m__b1_a3_1", "g3__gn_des_2m__b1_a2_1", "g3__gn_des_2m__b1_a3_1", "g3__gn_des_2m__b1_a4_1", "g3__gn_det_epi_plur_1m__b1_a1_1", "g3__gn_det_epi_plur_2m__b1_a2_1", "g3__gn_det_epi_plur_2m__b1_a3_1", "g3__gn_det_epi_plur_2m__b1_a4_1", "g3__gn_det_epi_plur_2m__b2_a3_1", "g3__gn_det_epi_plur_2m__b2_a4_1", "g3__gn_det_epi_plur_3m__b1_a3_1", "g3__gn_det_epi_plur_3m__b1_a4_1", "g3__gn_det_epi_sing_2m__b1_a2_1", "g3__gn_det_epi_sing_2m__b1_a3_1", "g3__gn_det_epi_sing_2m__b2_a2_1", "g3__gn_det_epi_sing_2m__b2_a3_1", "g3__gn_det_epi_sing_2m_virg__b1_a1_1", "g3__gn_det_epi_sing_3m__b1_a2_1", "g3__gn_det_fem_plur_2m__b1_a3_1", "g3__gn_det_fem_sing_2m__b1_a2_1", "g3__gn_det_fem_sing_2m__b1_a3_1", "g3__gn_det_fem_sing_2m__b2_a2_1", "g3__gn_det_fem_sing_2m_virg__b1_a1_1", "g3__gn_det_fem_sing_3m__b1_a1_1", "g3__gn_det_les_3m__b1_a2_1", "g3__gn_det_les_3m__b1_a3_1", "g3__gn_det_les_3m__b1_a4_1", "g3__gn_det_les_3m_et__b1_a2_1", "g3__gn_det_les_3m_et__b1_a3_1", "g3__gn_det_les_3m_et__b3_a5_1", "g3__gn_det_les_3m_et__b3_a6_1", "g3__gn_det_mas_plur_2m__b1_a2_1", "g3__gn_det_mas_plur_3m__b1_a1_1", "g3__gn_det_mas_sing_2m__b1_a2_1", "g3__gn_det_mas_sing_2m__b1_a3_1", "g3__gn_det_mas_sing_2m__b2_a2_1", "g3__gn_det_mas_sing_2m__b2_a3_1", "g3__gn_det_mas_sing_2m_virg__b1_a1_1", "g3__gn_det_mas_sing_3m__b1_a1_1", "g3__gn_det_mas_sing_3m_et__b3_a1_1", "g3__gn_det_mon_ton_son_3m__b1_a2_1", "g3__gn_det_mon_ton_son_3m_et__b4_a1_1", "g3__gn_det_nom_de_det_nom_adj_fem_sing__b1_a1_1", "g3__gn_det_nom_de_det_nom_adj_fem_sing__b3_a1_1", "g3__gn_det_nom_de_det_nom_adj_fem_sing__b7_a1_1", "g3__gn_det_nom_de_det_nom_adj_fem_sing__b9_a1_1", "g3__gn_det_nom_de_det_nom_adj_mas_sing__b1_a1_1", "g3__gn_det_nom_de_det_nom_adj_mas_sing__b3_a1_1", "g3__gn_det_nom_de_det_nom_adj_plur__b2_a1_1", "g3__gn_det_nom_de_det_nom_adj_sing__b1_a1_1", "g3__gn_det_nom_de_det_nom_adj_sing_plur__b1_a1_1", "g3__gn_det_nom_de_det_nom_adj_sing_plur__b2_a1_1", "g3__gn_det_nom_de_det_nom_adj_sing_plur__b6_a1_1", "g3__gn_det_nom_et_det_nom__b1_a1_1", "g3__gn_det_fem_plur_2m__b1_a2_1", "g3__gn_det_epi_plur_3m_et__b2_a2_1", "g3__gn_det_les_3m_et__b2_a2_1", "g3__gn_du_1m__b1_a1_1", "g3__gn_du_1m__b1_a2_1", "g3__gn_du_1m__b1_a3_1", "g3__gn_du_1m__b2_a1_1", "g3__gn_du_1m__b2_a2_1", "g3__gn_groupe_de__b2_a1_1", "g3__gn_groupe_de__b3_a1_1", "g3__gn_int\u00e9rieur_ext\u00e9rieur__b1_a1_1", "g3__gn_l_1m__b1_a1_1", "g3__gn_l_1m__b2_a1_1", "g3__gn_l_1m__b3_a1_1", "g3__gn_l_2m__b1_a2_1", "g3__gn_l_2m__b1_a3_1", "g3__gn_l_2m__b1_a4_1", "g3__gn_l_2m__b2_a2_1", "g3__gn_l_2m__b2_a3_1", "g3__gn_l_2m__b2_a4_1", "g3__gn_l_2m_virg__b1_a1_1", "g3__gn_l_3m__b1_a2_1", "g3__gn_l_3m__b1_a3_1", "g3__gn_la_1m__b1_a2_1", "g3__gn_la_1m__b1_a3_1", "g3__gn_la_1m__b2_a2_1", "g3__gn_la_1m__b2_a3_1", "g3__gn_la_1m__b2_a4_1", "g3__gn_la_1m__b3_a1_1", "g3__gn_la_1m__b3_a2_1", "g3__gn_la_1m__b3_a3_1", "g3__gn_la_2m__b1_a2_1", "g3__gn_la_2m__b1_a3_1", "g3__gn_la_2m__b1_a4_1", "g3__gn_la_2m__b2_a2_1", "g3__gn_la_2m__b2_a4_1", "g3__gn_la_2m__b3_a2_1", "g3__gn_la_2m__b3_a4_1", "g3__gn_la_2m_virg__b1_a1_1", "g3__gn_le_1m__b2_a2_1", "g3__gn_le_1m__b2_a3_1", "g3__gn_le_1m__b2_a4_1", "g3__gn_le_1m__b2_a5_1", "g3__gn_le_1m__b3_a2_1", "g3__gn_le_1m__b3_a3_1", "g3__gn_le_1m__b3_a4_1", "g3__gn_le_1m__b3_a5_1", "g3__gn_le_1m__b4_a1_1", "g3__gn_le_1m__b4_a2_1", "g3__gn_le_1m__b4_a3_1", "g3__gn_le_1m__b4_a4_1", "g3__gn_le_2m__b1_a2_1", "g3__gn_le_2m__b1_a3_1", "g3__gn_le_2m__b1_a4_1", "g3__gn_le_2m__b2_a2_1", "g3__gn_le_2m_virg__b1_a1_1", "g3__gn_le_3m__b1_a1_1", "g3__gn_le_3m_et__b1_a1_1", "g3__gn_le_3m_et__b2_a1_1", "g3__gn_les_1m__b1_a1_1", "g3__gn_les_1m__b2_a1_1", "g3__gn_les_1m__b3_a1_1", "g3__gn_les_2m__b1_a2_1", "g3__gn_les_2m__b1_a3_1", "g3__gn_les_2m__b2_a3_1", "g3__gn_les_2m__b1_a4_1", "g3__gn_les_2m__b2_a4_1", "g3__gn_les_2m_virg__b2_a1_1", "g3__gn_leur_1m__b1_a1_1", "g3__gn_leur_1m__b1_a2_1", "g3__gn_leur_1m__b2_a1_1", "g3__gn_leur_1m__b2_a2_1", "g3__gn_leur_2m__b1_a2_1", "g3__gn_leur_2m__b1_a4_1", "g3__gn_leur_2m__b1_a5_1", "g3__gn_leur_2m__b1_a5_1", "g3__gn_leur_2m__b2_a2_1", "g3__gn_leur_2m__b2_a4_1", "g3__gn_leurs_1m__b1_a1_1", "g3__gn_leurs_1m__b1_a2_1", "g3__gn_ma_ta_sa_1m__b1_a2_1", "g3__gn_ma_ta_sa_1m__b1_a3_1", "g3__gn_ma_ta_sa_1m__b1_a4_1", "g3__gn_mon_ton_son_1m__b1_a2_1", "g3__gn_mon_ton_son_1m__b1_a3_1", "g3__gn_mon_ton_son_1m__b1_a4_1", "g3__gn_mon_ton_son_2m__b1_a2_1", "g3__gn_mon_ton_son_2m__b1_a3_1", "g3__gn_mon_ton_son_2m__b1_a4_1", "g3__gn_mon_ton_son_2m__b2_a2_1", "g3__gn_nom_adj_2m__b1_a2_1", "g3__gn_nom_adj_2m__b1_a3_1", "g3__gn_nom_adj_2m__b1_a4_1", "g3__gn_nom_adj_2m__b1_a5_1", "g3__gn_nombre_chiffres_1m__b1_a1_1", "g3__gn_nombre_chiffres_1m__b2_a1_1", "g3__gn_nombre_chiffres_1m__b3_a2_1", "g3__gn_nombre_chiffres_1m__b3_a3_1", "g3__gn_nombre_chiffres_1m__b3_a4_1", "g3__gn_nombre_de_1m__b1_a1_1", "g3__gn_nombre_lettres_1m__b2_a1_1", "g3__gn_nombre_lettres_1m__b4_a1_1", "g3__gn_nombre_lettres_1m__b5_a1_1", "g3__gn_nombre_lettres_1m__b6_a1_1", "g3__gn_nombre_plur_2m__b1_a2_1", "g3__gn_nombre_plur_2m__b1_a3_1", "g3__gn_nombre_plur_2m__b1_a4_1", "g3__gn_notre_votre_chaque_1m__b1_a1_1", "g3__gn_nul_1m__b1_a1_1", "g3__gn_pfx_de_2m__b1_a2_1", "g3__gn_pfx_de_2m__b1_a3_1", "g3__gn_pfx_de_2m__b1_a4_1", "g3__gn_pfx_en_2m__b1_a1_1", "g3__gn_pfx_en_2m__b1_a2_1", "g3__gn_pfx_en_2m__b1_a3_1", "g3__gn_pfx_en_2m__b1_a4_1", "g3__gn_pfx_sur_avec_apr\u00e8s_2m__b1_a1_1", "g3__gn_pfx_sur_avec_apr\u00e8s_2m__b1_a2_1", "g3__gn_pfx_sur_avec_apr\u00e8s_2m__b1_a3_1", "g3__gn_pfx_sur_avec_apr\u00e8s_2m__b1_a4_1", "g3__gn_pfx_\u00e0_par_pour_sans_2m__b1_a1_1", "g3__gn_pfx_\u00e0_par_pour_sans_2m__b1_a2_1", "g3__gn_pfx_\u00e0_par_pour_sans_2m__b1_a3_1", "g3__gn_pfx_\u00e0_par_pour_sans_2m__b1_a4_1", "g3__gn_plein_de__b1_a1_1", "g3__gn_plusieurs_1m__b1_a1_1", "g3__gn_start_2m__b1_a1_1", "g3__gn_start_2m__b1_a2_1", "g3__gn_start_2m__b1_a3_1", "g3__gn_start_2m__b1_a4_1", "g3__gn_start_3m__b1_a1_1", "g3__gn_start_3m__b1_a2_1", "g3__gn_start_3m__b1_a3_1", "g3__gn_start_3m__b1_a4_1", "g3__gn_start_3m__b1_a5_1", "g3__gn_start_3m__b1_a6_1", "g3__gn_start_3m_et__b2_a2_1", "g3__gn_start_prn_1m__b1_a2_1", "g3__gn_un_1m__b2_a1_1", "g3__gn_un_1m__b2_a2_1", "g3__gn_un_1m__b2_a3_1", "g3__gn_un_2m__b1_a2_1", "g3__gn_un_2m__b1_a3_1", "g3__gn_un_2m__b1_a4_1", "g3__gn_un_2m__b2_a2_1", "g3__gn_un_2m__b2_a3_1", "g3__gn_un_2m__b2_a4_1", "g3__gn_un_des_1m__b1_a1_1", "g3__gn_un_des_1m__b1_a2_1", "g3__gn_une_1m__b1_a1_1", "g3__gn_une_1m__b1_a2_1", "g3__gn_une_1m__b1_a3_1", "g3__gn_une_2m__b1_a2_1", "g3__gn_une_2m__b1_a3_1", "g3__gn_une_2m__b1_a4_1", "g3__gn_une_2m__b2_a2_1", "g3__gn_une_2m__b2_a3_1", "g3__gn_une_2m__b2_a4_1", "g3__gn_une_2m_virg__b1_a1_1", "g3__gn_une_des_1m__b1_a1_1", "gv1__ppas_3pl_fem_verbe_\u00e9tat__b2_a1_1", "gv1__ppas_3pl_mas_verbe_\u00e9tat__b2_a1_1", "gv1__ppas_3pl_mas_verbe_\u00e9tat__b8_a1_1", "gv1__ppas_3sg_fem_verbe_\u00e9tat__b3_a1_1", "gv1__ppas_3sg_mas_verbe_\u00e9tat__b10_a1_1", "gv1__ppas_3sg_mas_verbe_\u00e9tat__b12_a1_2", "gv1__ppas_3sg_mas_verbe_\u00e9tat__b15_a1_1", "gv1__ppas_3sg_mas_verbe_\u00e9tat__b4_a1_1", "gv1__ppas_3sg_mas_verbe_\u00e9tat__b4_a1_2", "gv1__ppas_3sg_mas_verbe_\u00e9tat__b5_a1_1", "gv1__ppas_3sg_mas_verbe_\u00e9tat__b6_a2_1", "gv1__ppas_adj_accord_il__b1_a1_1", "gv1__ppas_adj_accord_ils__b1_a1_1", "gv1__ppas_adj_\u00eatre_det_nom__b2_a1_1", "gv1__ppas_adj_\u00eatre_det_nom__b3_a2_1", "gv1__ppas_avoir__b1_a1_1", "gv1__ppas_avoir_l_air__b5_a1_1", "gv1__ppas_avoir_l_air__b9_a2_1", "gv1__ppas_avoir_\u00e9t\u00e9__b2_a1_1", "gv1__ppas_det_plur_COD_que_avoir__b1_a3_1", "gv1__ppas_det_sing_COD_que_avoir__b4_a3_1", "gv1__ppas_fin_loc_verb_\u00e9tat_adj_et_adj__b1_a1_1", "gv1__ppas_je_tu_verbe_\u00e9tat__b1_a1_1", "gv1__ppas_je_tu_verbe_\u00e9tat__b2_a1_1", "gv1__ppas_je_tu_verbe_\u00e9tat__b3_a1_1", "gv1__ppas_le_verbe_pens\u00e9e__b1_a1_1", "gv1__ppas_nous_verbe_\u00e9tat__b2_a1_1", "gv1__ppas_\u00eatre_accord_plur__b2_a1_1", "gv1__ppas_\u00eatre_accord_plur__b1_a1_1", "gv1__ppas_\u00eatre_accord_sing__b1_a1_1", "gv2__conf_ait_confiance_\u00e9t\u00e9_faim_tort__b1_a2_1", "gv1__conf_suj_verbe_det_verbe_nom__b5_a1_1", "gv2__conj_les_nom__b1_a2_1", "gv2__conj_quiconque__b1_a1_1", "g2__conf_a_\u00e0_substantifs__b1_a1_1", "g2__conf_a_\u00e0_verbe__b14_a2_1", "g2__conf_a_\u00e0_verbe__b14_a3_1", "g2__conf_a_\u00e0_verbe__b14_a6_1", "g2__conf_a_\u00e0_verbe__b15_a2_1", "g2__conf_a_\u00e0_verbe__b15_a3_1", "g2__conf_a_\u00e0_verbe__b1_a1_1", "g2__conf_celui_celle_\u00e0_qui__b1_a1_1", "g2__conf_\u00e0_a__b1_a1_1", "g2__conf_\u00e0_a__b2_a1_1", "g2__conf_\u00e0_a__b7_a1_1", "g2__conf_\u00e0_a_infinitif__b1_a1_1", "g2__conf_\u00e0_a__b3_a1_1", "g2__conf_\u00e0_a__b4_a1_1", "g2__conf_\u00e0_a__b5_a1_1", "g2__conf_\u00e0_qui_infinitif__b1_a1_1", "g3__conf_\u00e0_a_apr\u00e8s_verbes__b2_a1_1", "g3__infi_\u00e0_verbe__b2_a1_1", "g3__infi_\u00e0_verbe__b3_a1_1", "g3__infi_de_verbe__b4_a1_1", "g3__infi_de_verbe__b5_a1_1", "g3__infi_de_verbe__b6_a1_1", "g3__infi_savoir__b2_a1_1", "gv1__ppas_avoir__b2_a1_1", "gv1__ppas_avoir__b3_a1_1", "gv1__ppas_avoir__b4_a1_1", "g2__eleu_\u00e9lisions_manquantes__b1_a1_1", "g2__eleu_\u00e9lisions_manquantes__b2_a1_1", "g2__eleu_\u00e9lisions_manquantes__b4_a1_1", "g2__eleu_\u00e9lisions_manquantes__b5_a1_1", "g2__eleu_\u00e9lisions_manquantes__b6_a1_1", "g2__conf_a_\u00e0_incoh\u00e9rences__b1_a1_1", "g2__conf_a_\u00e0_verbe__b11_a1_1", "g2__conf_a_\u00e0_verbe__b13_a1_1", "g2__conf_a_\u00e0_verbe__b14_a7_1", "g2__conf_a_\u00e0_verbe__b3_a1_1", "g2__conf_a_\u00e0_verbe__b4_a1_1", "g2__conf_a_\u00e0_verbe__b7_a1_1", "g2__conf_a_\u00e0_verbe__b8_a1_1", "g2__conf_quand_quant_qu_en__b1_a1_1", "g3__gn_de_mani\u00e8re_fa\u00e7on_1m", "g3__gn_de_mani\u00e8re_fa\u00e7on_1m__b1_a2_1", "g3__gn_la_3m__b1_a1_1", "gv1__imp_verbe_groupe3_d__b2_a1_1", "typo_guillemets_perdus", "g2__conj_2p_sans_sujet__b1_a1_1", "typo_signe_multiplication", "typo_\u00e9criture_invariable", "gv1__ppas_avoir_\u00e9t\u00e9__b2_a3_1", "gv1__ppas_sujet_\u00eatre_accord_singulier__b2_a1_1", "num_grand_nombre_avec_points", "g2__conj_tu__b1_a1_1", "typo_guillemets_doubles_ouvrants_non_ferm\u00e9", "g2__maj_gentil\u00e9s__b3_a1_1", "g2__maj_gentil\u00e9s__b3_a2_1", "g2__maj_Dieu__b1_a1_1", "g2__maj_jours_semaine__b1_a1_1", "typo_signe_moins", "g3__conf_num\u00e9rique_digital__b1_a1_1", "g2__conf_start_nom_ppas__b1_a1_1", "typo_guillemets_fin", "g2__conf_non_verbe_apr\u00e8s_pr\u00e9verbes__b2_a1_1", "g2__typo_ordinaux_chiffres_romains_exposants__b9_a1_1", "g3__gn_pfx_de_2m__b1_a1_1", "eepi_\u00e9criture_\u00e9pic\u00e8ne_singulier", "eepi_\u00e9criture_\u00e9pic\u00e8ne_pluriel_e", "eepi_\u00e9criture_\u00e9pic\u00e8ne_pluriel_er_\u00e8re", "eepi_\u00e9criture_\u00e9pic\u00e8ne_tous_toutes", "eepi_\u00e9criture_\u00e9pic\u00e8ne_pluriel_eux_euses", "eepi_\u00e9criture_\u00e9pic\u00e8ne_pluriel_eur_divers", "g2__chim_mol\u00e9cules__b1_a1_1", "g3__conf_num\u00e9rique_digital__b2_a1_1", "doublon", "typo_guillemets_doubles_fermants_non_ouverts", "g2__conf_non_verbe_apr\u00e8s_pr\u00e9verbes__b5_a3_1", "gv1__imp_verbe_groupe2_groupe3_t__b2_a1_1", "gv2__conj_les_nom__b1_a3_1", "gv2__vmode_verbe_que_subjonctif__b1_a1_1", "g2__conj_1p_sans_sujet__b1_a1_1", "typo_points_suspension_apr\u00e8s_espace", "typo_guillemets_doubles_ouvrants_non_ferm\u00e9s", "g2__conf_de_vconj__b1_a1_1", "g2__conf_d\u00e9terminant_mas_sing_verbe__b1_a1_1", "g2__conj_2s_sans_sujet_xxxas_xxxes__b4_a1_", "typo_points_superflus", "g2__conf_la_l\u00e0__b2_a1_1", "g2__conj_2s_sans_sujet_xxxas_xxxes__b4_a1_1", "g2__conf_non_verbe_apr\u00e8s_pr\u00e9verbes__b5_a2_1", "g2__conj_je__b2_a1_1", "gv1__conf_vc_int_imp_verbe__b1_a1_1", "gv1__conf_le_la_leur_les_verbe_nom__b1_a1_1", "date_nombres", "gv1__imp_confusion_2e_pers_pluriel__b5_a1_1", "g2__conf_tu_non_verbe__b1_a3_1", "g2__conf_si_vconj__b2_a1_1", "g2__conf_on_non_verbe__b1_a3_1", "g2__conf_on_non_verbe__b2_a3_1", "g2__conj_on__b1_a1_1", "g3__gn_start_prn_1m__b1_a1_1", "gv2__conj_vinfi_suj__b1_a1_1", "g2__conf_plus_plu__b5_a1_1", "g3__gn_det_epi_plur_3m__b1_a2_1", "g3__gn_det_epi_sing_3m__b1_a3_1", "g2__conf_sur_vconj__b1_a1_1", "typo_guillemets_ouvrants_inverses1", "typo_guillemets_ouvrants_inverses2", "typo_guillemets_ouvrants_inverses3", "typo_guillemets_fermants_inverses", "typo_commencement_guillemets", "typo_guillemets_typographiques_simples_doubles_fermants", "typo_guillemets_typographiques_simples_doubles_ouvrants", "typo_guillemets_ouvrants_perdus", "typo_guillemets_fermants_perdus", "typo_guillemet_simple_fermant_non_ouvert", "typo_guillemet_simple_ouvrant_non_ferm\u00e9", "typo_coh\u00e9rence_guillemets_chevrons_fermants", "typo_coh\u00e9rence_guillemets_chevrons_ouvrants", "typo_coh\u00e9rence_guillemets_doubles_fermants", "typo_coh\u00e9rence_guillemets_doubles_ouvrants", "g2__conf_par_vconj__b1_a1_1", "g2__conf_a_\u00e0_verbe__b15_a7_1", "typo_espace_avant_signe_fermant", "g2__date_journ\u00e9e_jour_mois_ann\u00e9e__b1_a1_4", "g2__conf_incoh\u00e9rences_globales__b3_a1_1", "g2__typo_ordinaux_chiffres_incorrects__b9_a1_1", "g2__conj_1s_sans_sujet_xxxai__b4_a1_1", "g2__conf_d\u00e8s_des_d\u00e9s__b3_a2_1", "g2__pleo_substantifs__b11_a1_1", "g2__pleo_substantifs__b12_a1_1", "g2__pleo_substantifs__b1_a1_1", "g2__pleo_verbes__b4_a1_1", "g2__pleo_verbes__b8_a1_1", "g2__pleo_locutions__b7_a1_1", "g2__pleo_verbes__b7_a1_1", "g2__conf_de_du_d__b1_a1_1", "g2__conf_faux_faut__b1_a1_1", "g2__conf_poing_point__b1_a1_1", "g3__conf_foi_fois_foie__b3_a1_1", "g3__conf_faim_fin__b1_a1_1t", "gv2__conf_et_est2__b9_a1_1", "g3__conf_est_et__b4_a1_1", "g2__conf_pr\u00e8s_pr\u00eat_pr\u00e9__b3_a1_1", "g3__conf_panser_penser__b1_a1_1", "g3__conf_tache_t\u00e2che__b1_a1_1", "g2__conf_de_vconj__b6_a1_1", "g2__conf_\u00e0_vconj__b3_a1_1", "gv1__ppas_\u00eatre_confusion__b4_a4_1", "gv2__conj_moi_qui__b1_a1_1", "gv2__conj_3sg_misc__b1_a1_1", "g3__gn_leur_2m__b1_a3_1", "g2__tu_pronoms_dits__b2_a1_1", "g2__conf_tu_non_verbe__b1_a2_1", "g2__conf_il_non_verbe__b2_a2_1", "g2__conf_il_non_verbe__b2_a3_1", "g2__conf_non_verbe_apr\u00e8s_pr\u00e9verbes__b2_a2_1", "g2__conf_non_verbe_apr\u00e8s_pr\u00e9verbes__b3_a2_1", "g2__conf_non_verbe_apr\u00e8s_pr\u00e9verbes__b6_a3_1", "g2__conf_incoh\u00e9rences_globales__b1_a1_1", "g2__conf_incoh\u00e9rences_globales__b2_a1_1", "g2__conj_ce__b3_a1_1", "g2__conf_de_vconj__b3_a1_1", "g2__conf_a_\u00e0_incoh\u00e9rences__b2_a1_1", "g2__conj_il__b1_a1_1", "g2__conf_d\u00e9terminant_plur_verbe__b3_a3_1", "g2__bs_vid\u00e9oprotection__b1_a1_1", "g0__inte_verbes_compos\u00e9s_interrogatifs__b8_a2_1", "gv2__conj_que_o\u00f9_comment_verbe_sans_sujet__b1_a2_1", "gv2__conf_et_est2__b1_a1_1", "g2__conf_d\u00e8s_des_d\u00e9s__b9_a1_1", "g2__conf_se_\u00eatre_avoir__b5_a2_1", "g2__conf_pr\u00e9verbes__b4_a1_1", "gv2__conj_des_nom__b1_a3_1", "gv1__ppas_\u00eatre_confusion__b4_a2_1", "gv1__conf_verbes_det_verbe_nom__b1_a1_1", "g2__typo_ordinaux_chiffres_exposants__b5_a1_1", "g2__conf_d\u00e8s_des_d\u00e9s__b5_a1_1", "g3__infi_faire__b2_a1_1", "g3__infi_verbes__b4_a1_1"));

    public GrammalecteRule(ResourceBundle messages, GlobalConfig globalConfig) {
        super(messages);
        this.globalConfig = globalConfig;
    }

    public String getId() {
        return "FR_GRAMMALECTE";
    }

    public String getDescription() {
        return "Returns matches of a local Grammalecte server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        Object encoded;
        if (System.currentTimeMillis() - lastRequestError < 5000L) {
            logger.warn("Warn: Temporarily disabled Grammalecte server because of recent error.");
            return new RuleMatch[0];
        }
        URL serverUrl = new URL(this.globalConfig.getGrammalecteServer());
        HttpURLConnection huc = (HttpURLConnection)serverUrl.openConnection();
        HttpURLConnection.setFollowRedirects(false);
        huc.setConnectTimeout(500);
        huc.setReadTimeout(1000);
        if (this.globalConfig.getGrammalecteUser() != null && this.globalConfig.getGrammalectePassword() != null) {
            String authString = this.globalConfig.getGrammalecteUser() + ":" + this.globalConfig.getGrammalectePassword();
            encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            huc.setRequestProperty("Authorization", "Basic " + (String)encoded);
        }
        huc.setRequestMethod("POST");
        huc.setDoOutput(true);
        try {
            huc.connect();
            DataOutputStream wr = new DataOutputStream(huc.getOutputStream());
            encoded = null;
            try {
                String urlParameters = "text=" + this.encode(sentence.getText());
                byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
                wr.write(postData);
            }
            catch (Throwable throwable) {
                encoded = throwable;
                throw throwable;
            }
            finally {
                if (wr != null) {
                    if (encoded != null) {
                        try {
                            wr.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)encoded).addSuppressed(throwable);
                        }
                    } else {
                        wr.close();
                    }
                }
            }
            InputStream input = huc.getInputStream();
            List<RuleMatch> ruleMatches = this.parseJson(input);
            RuleMatch[] ruleMatchArray = this.toRuleMatchArray(ruleMatches);
            return ruleMatchArray;
        }
        catch (Exception e) {
            lastRequestError = System.currentTimeMillis();
            logger.warn("Warn: Failed to query Grammalecte server at " + serverUrl, (Throwable)e);
        }
        finally {
            huc.disconnect();
        }
        return new RuleMatch[0];
    }

    @NotNull
    private List<RuleMatch> parseJson(InputStream inputStream) throws IOException {
        Map map = (Map)this.mapper.readValue(inputStream, Map.class);
        ArrayList matches = (ArrayList)map.get("data");
        if (matches == null) {
            throw new RuntimeException("No 'data' found in grammalecte JSON: " + map);
        }
        ArrayList<RuleMatch> result = new ArrayList<RuleMatch>();
        for (Object match : matches) {
            List<RuleMatch> remoteMatches = this.getMatches((Map)match);
            result.addAll(remoteMatches);
        }
        return result;
    }

    protected String encode(String plainText) throws UnsupportedEncodingException {
        return URLEncoder.encode(plainText, StandardCharsets.UTF_8.name());
    }

    @NotNull
    private List<RuleMatch> getMatches(Map<String, Object> match) {
        ArrayList<RuleMatch> remoteMatches = new ArrayList<RuleMatch>();
        ArrayList matches = (ArrayList)match.get("lGrammarErrors");
        for (Object o : matches) {
            Map pairs = (Map)o;
            int offset = (Integer)pairs.get("nStart");
            int endOffset = (Integer)pairs.get("nEnd");
            String id = (String)pairs.get("sRuleId");
            if (ignoreRules.contains(id)) continue;
            String message = pairs.get("sMessage").toString();
            GrammalecteInternalRule rule = new GrammalecteInternalRule("grammalecte_" + id, message);
            RuleMatch extMatch = new RuleMatch((Rule)rule, null, offset, endOffset, message);
            List suggestions = (List)pairs.get("aSuggestions");
            extMatch.setSuggestedReplacements(suggestions);
            remoteMatches.add(extMatch);
        }
        return remoteMatches;
    }

    static class GrammalecteInternalRule
    extends Rule {
        private final String id;
        private final String desc;

        GrammalecteInternalRule(String id, String desc) {
            this.id = id;
            this.desc = desc;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.desc;
        }

        public RuleMatch[] match(AnalyzedSentence sentence) {
            throw new RuntimeException("Not implemented");
        }
    }
}

