/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.fr.AnglicismReplaceRule;
import org.languagetool.rules.fr.CompoundRule;
import org.languagetool.rules.fr.FrenchConfusionProbabilityRule;
import org.languagetool.rules.fr.FrenchRepeatedWordsRule;
import org.languagetool.rules.fr.GrammalecteRule;
import org.languagetool.rules.fr.MorfologikFrenchSpellerRule;
import org.languagetool.rules.fr.QuestionWhitespaceRule;
import org.languagetool.rules.fr.QuestionWhitespaceStrictRule;
import org.languagetool.rules.fr.SimpleReplaceRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.fr.FrenchHybridDisambiguator;
import org.languagetool.tagging.fr.FrenchTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.fr.FrenchWordTokenizer;

public class French
extends Language
implements AutoCloseable {
    private LanguageModel languageModel;

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public String getName() {
        return "French";
    }

    public String getShortCode() {
        return "fr";
    }

    public String[] getCountries() {
        return new String[]{"FR", "", "BE", "CH", "CA", "LU", "MC", "CM", "CI", "HT", "ML", "SN", "CD", "MA", "RE"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return FrenchTagger.INSTANCE;
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new FrenchSynthesizer(this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new FrenchWordTokenizer();
    }

    public Disambiguator createDefaultDisambiguator() {
        return new FrenchHybridDisambiguator();
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.DOMINIQUE_PELLE};
    }

    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikFrenchSpellerRule(messages, this, null, Collections.emptyList());
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, false), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{"), Arrays.asList("]", ")", "}")), new MorfologikFrenchSpellerRule(messages, this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new LongSentenceRule(messages, userConfig, 40), new LongParagraphRule(messages, (Language)this, userConfig), new CompoundRule(messages, this, userConfig), new QuestionWhitespaceStrictRule(messages, this), new QuestionWhitespaceRule(messages, this), new SimpleReplaceRule(messages), new AnglicismReplaceRule(messages), new FrenchRepeatedWordsRule(messages)});
    }

    public List<Rule> getRelevantRulesGlobalConfig(ResourceBundle messages, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (globalConfig != null && globalConfig.getGrammalecteServer() != null) {
            rules.add(new GrammalecteRule(messages, globalConfig));
        }
        return rules;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new FrenchConfusionProbabilityRule(messages, languageModel, this)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public String toAdvancedTypography(String input) {
        String output = super.toAdvancedTypography(input);
        String beforeApostrophe = "([cjnmtsldCJNMTSLD]|qu|jusqu|lorsqu|puisqu|quoiqu|Qu|Jusqu|Lorsqu|Puisqu|Quoiqu|QU|JUSQU|LORSQU|PUISQU|QUOIQU)";
        output = output.replaceAll("(\\b" + beforeApostrophe + ")'", "$1\u2019");
        output = output.replaceAll("(\\b" + beforeApostrophe + ")\u2019\"", "$1\u2019" + this.getOpeningDoubleQuote());
        output = output.replaceAll("(\\b" + beforeApostrophe + ")\u2019'", "$1\u2019" + this.getOpeningSingleQuote());
        output = output.replaceAll("\u00a0;", "\u202f;");
        output = output.replaceAll("\u00a0!", "\u202f!");
        output = output.replaceAll("\u00a0\\?", "\u202f?");
        output = output.replaceAll(";", "\u202f;");
        output = output.replaceAll("!", "\u202f!");
        output = output.replaceAll("\\?", "\u202f?");
        output = output.replaceAll(":", "\u00a0:");
        output = output.replaceAll("\u00bb", "\u00a0\u00bb");
        output = output.replaceAll("\u00ab", "\u00ab\u00a0");
        output = output.replaceAll("\u00a0\u00a0", "\u00a0");
        output = output.replaceAll("\u202f\u202f", "\u202f");
        output = output.replaceAll("  ", " ");
        output = output.replaceAll("\u00a0 ", "\u00a0");
        output = output.replaceAll(" \u00a0", "\u00a0");
        output = output.replaceAll(" \u202f", "\u202f");
        output = output.replaceAll("\u202f ", "\u202f");
        return output;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "FR_COMPOUNDS": {
                return 500;
            }
            case "FR_SIMPLE_REPLACE": {
                return 150;
            }
            case "AGREEMENT_EXCEPTIONS": {
                return 100;
            }
            case "EXPRESSIONS_VU": {
                return 100;
            }
            case "SA_CA_SE": {
                return 100;
            }
            case "SIL_VOUS_PLAIT": {
                return 100;
            }
            case "QUASI_NOM": {
                return 100;
            }
            case "MA": {
                return 100;
            }
            case "SON_SONT": {
                return 100;
            }
            case "JE_TES": {
                return 100;
            }
            case "A_INFINITIF": {
                return 100;
            }
            case "ON_ONT": {
                return 100;
            }
            case "LEURS_LEUR": {
                return 100;
            }
            case "DU_DU": {
                return 100;
            }
            case "ACCORD_CHAQUE": {
                return 100;
            }
            case "J_N2": {
                return 100;
            }
            case "CEST_A_DIRE": {
                return 100;
            }
            case "FAIRE_VPPA": {
                return 100;
            }
            case "D_N_E_OU_E": {
                return 100;
            }
            case "GENS_ACCORD": {
                return 100;
            }
            case "VIRGULE_EXPRESSIONS_FIGEES": {
                return 100;
            }
            case "TRAIT_UNION": {
                return 100;
            }
            case "PLURIEL_AL2": {
                return 100;
            }
            case "FR_SPLIT_WORDS_HYPHEN": {
                return 100;
            }
            case "PAS_DE_TRAIT_UNION": {
                return 50;
            }
            case "PRIME-TIME": {
                return 50;
            }
            case "A_VERBE_INFINITIF": {
                return 20;
            }
            case "DE_OU_DES": {
                return 20;
            }
            case "EMPLOI_EMPLOIE": {
                return 20;
            }
            case "VOIR_VOIRE": {
                return 20;
            }
            case "CAT_TYPOGRAPHIE": {
                return 20;
            }
            case "CAT_HOMONYMES_PARONYMES": {
                return 20;
            }
            case "CAT_TOURS_CRITIQUES": {
                return 20;
            }
            case "D_VPPA": {
                return 20;
            }
            case "EST_CE_QUE": {
                return 20;
            }
            case "CONFUSION_PARLEZ_PARLER": {
                return 10;
            }
            case "AGREEMENT_TOUT_LE": {
                return 10;
            }
            case "ESPACE_UNITES": {
                return 10;
            }
            case "BYTES": {
                return 10;
            }
            case "Y_A": {
                return 10;
            }
            case "COTE": {
                return 10;
            }
            case "PEUTETRE": {
                return 10;
            }
            case "A_A_ACCENT": {
                return 10;
            }
            case "A_ACCENT_A": {
                return 10;
            }
            case "A_A_ACCENT2": {
                return 10;
            }
            case "A_ACCENT": {
                return 10;
            }
            case "JE_M_APPEL": {
                return 10;
            }
            case "ACCORD_R_PERS_VERBE": {
                return 10;
            }
            case "JE_SUI": {
                return 10;
            }
            case "R_VAVOIR_VINF": {
                return 10;
            }
            case "AN_EN": {
                return 10;
            }
            case "APOS_M": {
                return 10;
            }
            case "ACCORD_PLURIEL_ORDINAUX": {
                return 10;
            }
            case "SUJET_AUXILIAIRE": {
                return 10;
            }
            case "ADJ_ADJ_SENT_END": {
                return 10;
            }
            case "SE_CE": {
                return -10;
            }
            case "SYNONYMS": {
                return -10;
            }
            case "PAS_DE_SOUCIS": {
                return 10;
            }
            case "CONFUSION_PAR_PART": {
                return -5;
            }
            case "SON": {
                return -5;
            }
            case "J_N": {
                return -10;
            }
            case "TE_NV": {
                return -20;
            }
            case "TE_NV2": {
                return -10;
            }
            case "PLURIEL_AL": {
                return -10;
            }
            case "INTERROGATIVE_DIRECTE": {
                return -10;
            }
            case "D_J_N": {
                return -10;
            }
            case "FAMILIARITES": {
                return -10;
            }
            case "V_J_A_R": {
                return -10;
            }
            case "TRES_TRES_ADJ": {
                return -10;
            }
            case "IMP_PRON": {
                return -10;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
            case "PREP_VERBECONJUGUE": {
                return -20;
            }
            case "LA_LA2": {
                return -20;
            }
            case "FRENCH_WORD_REPEAT_RULE": {
                return -20;
            }
            case "CROIRE": {
                return -20;
            }
            case "PAS_DE_VERBE_APRES_POSSESSIF_DEMONSTRATIF": {
                return -20;
            }
            case "VIRGULE_VERBE": {
                return -20;
            }
            case "VERBES_FAMILIERS": {
                return -25;
            }
            case "VERB_PRONOUN": {
                return -50;
            }
            case "IL_VERBE": {
                return -50;
            }
            case "A_LE": {
                return -50;
            }
            case "ILS_VERBE": {
                return -50;
            }
            case "AGREEMENT_POSTPONED_ADJ": {
                return -50;
            }
            case "MULTI_ADJ": {
                return -50;
            }
            case "PARENTHESES": {
                return -50;
            }
            case "ESSENTIEL": {
                return -50;
            }
            case "CONFUSION_AL_LA": {
                return -50;
            }
            case "IMPORTANT": {
                return -50;
            }
            case "SOUHAITER": {
                return -50;
            }
            case "CAR": {
                return -50;
            }
            case "AIMER": {
                return -50;
            }
            case "CONFUSION_RULE_PREMIUM": {
                return -50;
            }
            case "FR_SPELLING_RULE": {
                return -100;
            }
            case "VIRG_INF": {
                return -100;
            }
            case "ET_SENT_START": {
                return -151;
            }
            case "MAIS_SENT_START": {
                return -151;
            }
            case "EN_CE_QUI_CONCERNE": {
                return -152;
            }
            case "EN_MEME_TEMPS": {
                return -152;
            }
            case "ET_AUSSI": {
                return -152;
            }
            case "MAIS_AUSSI": {
                return -152;
            }
            case "ELISION": {
                return -200;
            }
            case "POINT": {
                return -200;
            }
            case "REPETITIONS_STYLE": {
                return -250;
            }
            case "FR_REPEATEDWORDS_EXIGER": {
                return -250;
            }
            case "POINTS_SUSPENSIONS_SPACE": {
                return -250;
            }
            case "UPPERCASE_SENTENCE_START": {
                return -300;
            }
            case "FRENCH_WHITESPACE_STRICT": {
                return -350;
            }
            case "TOUT_MAJUSCULES": {
                return -400;
            }
            case "VIRG_NON_TROUVEE": {
                return -400;
            }
            case "POINTS_2": {
                return -400;
            }
            case "MOTS_INCOMP": {
                return -400;
            }
            case "FRENCH_WHITESPACE": {
                return -400;
            }
            case "MOT_TRAIT_MOT": {
                return -400;
            }
            case "FRENCH_WORD_REPEAT_BEGINNING_RULE": {
                return -350;
            }
        }
        if (id.startsWith("grammalecte_")) {
            return -150;
        }
        if (id.startsWith("AI_FR_HYDRA_LEO")) {
            return -101;
        }
        return super.getPriorityForId(id);
    }

    public boolean hasMinMatchesRules() {
        return true;
    }

    public List<RuleMatch> adaptSuggestions(List<RuleMatch> ruleMatches, Set<String> enabledRules) {
        if (enabledRules.contains("APOS_TYP")) {
            ArrayList<RuleMatch> newRuleMatches = new ArrayList<RuleMatch>();
            for (RuleMatch rm : ruleMatches) {
                List replacements = rm.getSuggestedReplacements();
                ArrayList<String> newReplacements = new ArrayList<String>();
                for (String s : replacements) {
                    if (s.length() > 1) {
                        s = s.replace("'", "\u2019");
                    }
                    newReplacements.add(s);
                }
                RuleMatch newMatch = new RuleMatch(rm, newReplacements);
                newRuleMatches.add(newMatch);
            }
            return newRuleMatches;
        }
        return ruleMatches;
    }
}

