/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tagging.fr.FrenchTagger;
import org.languagetool.tools.StringTools;

public final class MorfologikFrenchSpellerRule
extends MorfologikSpellerRule {
    private static final String SPELLING_FILE = "/fr/hunspell/spelling.txt";
    private static final Pattern PARTICULA_INICIAL = Pattern.compile("^(non|en|a|le|la|les|pour|de|du|des|un|une|mon|ma|mes|ton|ta|tes|son|sa|ses|leur|leurs|ce|cet) (..+)$", 66);
    private static final Pattern PREFIX_AMB_ESPAI = Pattern.compile("^(agro|anti|archi|auto|a\u00e9ro|cardio|co|cyber|demi|ex|extra|g\u00e9o|hospitalo|hydro|hyper|hypo|infra|inter|macro|mega|meta|mi|micro|mini|mono|multi|musculo|m\u00e9ga|m\u00e9ta|n\u00e9o|omni|pan|para|pluri|poly|post|prim|pro|proto|pr\u00e9|pseudo|psycho|p\u00e9ri|re|retro|r\u00e9|semi|simili|socio|super|supra|sus|trans|tri|t\u00e9l\u00e9|ultra|uni|vice|\u00e9co|[^ay\u00e0]) (..+)$", 66);
    private static final Pattern APOSTROF_INICI_VERBS = Pattern.compile("^([lnts])(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].*[^\u00e8])$", 66);
    private static final Pattern APOSTROF_INICI_VERBS_M = Pattern.compile("^(m)(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].*[^\u00e8])$", 66);
    private static final Pattern APOSTROF_INICI_VERBS_C = Pattern.compile("^(c)([ei\u00e9\u00e8\u00ea].*)$", 66);
    private static final Pattern APOSTROF_INICI_NOM_SING = Pattern.compile("^([ld])(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa]...+)$", 66);
    private static final Pattern APOSTROF_INICI_NOM_PLURAL = Pattern.compile("^(d)(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].+)$", 66);
    private static final Pattern APOSTROF_INICI_VERBS_INF = Pattern.compile("^([lntsmd]|nous|vous)(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].*[^\u00e8])$", 66);
    private static final Pattern HYPHEN_ON = Pattern.compile("^([\\p{L}]+[^aeiou])[\u2019']?(il|elle|ce|on)$", 66);
    private static final Pattern HYPHEN_JE = Pattern.compile("^([\\p{L}]+[^e])[\u2019']?(je)$", 66);
    private static final Pattern HYPHEN_TU = Pattern.compile("^([\\p{L}]+)[\u2019']?(tu)$", 66);
    private static final Pattern HYPHEN_NOUS = Pattern.compile("^([\\p{L}]+)[\u2019']?(nous)$", 66);
    private static final Pattern HYPHEN_VOUS = Pattern.compile("^([\\p{L}]+)[\u2019']?(vous)$", 66);
    private static final Pattern HYPHEN_ILS = Pattern.compile("^([\\p{L}]+)[\u2019']?(ils|elles)$", 66);
    private static final Pattern IMPERATIVE_HYPHEN = Pattern.compile("^([\\p{L}]+)[\u2019']?(moi|toi|le|la|lui|nous|vous|les|leur|y|en)$", 66);
    private static final Pattern VERB_INDSUBJ = Pattern.compile("V .*(ind|sub).*");
    private static final Pattern VERB_IMP = Pattern.compile("V.* imp .*");
    private static final Pattern VERB_INF = Pattern.compile("V.* inf");
    private static final Pattern VERB_INDSUBJ_M = Pattern.compile("V .* [123] s|V .* [23] p");
    private static final Pattern VERB_INDSUBJ_C = Pattern.compile("V .* 3 s");
    private static final Pattern NOM_SING = Pattern.compile("[NJZ] .* (s|sp)|V .inf|V .*ppa.* s");
    private static final Pattern NOM_PLURAL = Pattern.compile("[NJZ] .* (p|sp)|V .*ppa.* p");
    private static final Pattern VERB_1S = Pattern.compile("V .*(ind).* 1 s");
    private static final Pattern VERB_2S = Pattern.compile("V .*(ind).* 2 s");
    private static final Pattern VERB_3S = Pattern.compile("V .*(ind).* 3 s");
    private static final Pattern VERB_1P = Pattern.compile("V .*(ind).* 1 p");
    private static final Pattern VERB_2P = Pattern.compile("V .*(ind).* 2 p");
    private static final Pattern VERB_3P = Pattern.compile("V .*(ind).* 3 p");
    private final String dictFilename;

    public MorfologikFrenchSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.setIgnoreTaggedWords();
        this.dictFilename = "/fr/french.dict";
    }

    public String getFileName() {
        return this.dictFilename;
    }

    public String getSpellingFileName() {
        return SPELLING_FILE;
    }

    public String getId() {
        return "FR_SPELLING_RULE";
    }

    public boolean useInOffice() {
        return true;
    }

    protected List<SuggestedReplacement> orderSuggestions(List<SuggestedReplacement> suggestions, String word) {
        ArrayList<SuggestedReplacement> newSuggestions = new ArrayList<SuggestedReplacement>();
        for (int i = 0; i < suggestions.size(); ++i) {
            if (PREFIX_AMB_ESPAI.matcher(suggestions.get(i).getReplacement()).matches()) continue;
            Matcher matcher = PARTICULA_INICIAL.matcher(suggestions.get(i).getReplacement());
            if (matcher.matches()) {
                newSuggestions.add(0, suggestions.get(i));
                continue;
            }
            String suggWithoutDiacritics = StringTools.removeDiacritics((String)suggestions.get(i).getReplacement());
            if (word.equalsIgnoreCase(suggWithoutDiacritics) && suggestions.get(0).getReplacement().contains("'")) {
                newSuggestions.add(0, suggestions.get(i));
                continue;
            }
            String cleanSuggestion = suggestions.get(i).getReplacement().replaceAll("'", "").replaceAll("-", "");
            if (i > 1 && suggestions.size() > 2 && cleanSuggestion.equalsIgnoreCase(word)) {
                newSuggestions.add(1, suggestions.get(i));
                continue;
            }
            newSuggestions.add(suggestions.get(i));
        }
        return newSuggestions;
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> suggestionsList = suggestions.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        return SuggestedReplacement.convert(this.getAdditionalTopSuggestionsString(suggestionsList, word));
    }

    private List<String> getAdditionalTopSuggestionsString(List<String> suggestions, String word) throws IOException {
        if (word.equals("voulai")) {
            return Arrays.asList("voulais", "voulait");
        }
        if (word.toLowerCase().equals("mm2")) {
            return Arrays.asList("mm\u00b2");
        }
        if (word.toLowerCase().equals("cm2")) {
            return Arrays.asList("cm\u00b2");
        }
        if (word.toLowerCase().equals("dm2")) {
            return Arrays.asList("dm\u00b2");
        }
        if (word.toLowerCase().equals("m2")) {
            return Arrays.asList("m\u00b2");
        }
        if (word.toLowerCase().equals("km2")) {
            return Arrays.asList("km\u00b2");
        }
        if (word.toLowerCase().equals("mm3")) {
            return Arrays.asList("mm\u00b3");
        }
        if (word.toLowerCase().equals("cm3")) {
            return Arrays.asList("cm\u00b3");
        }
        if (word.toLowerCase().equals("dm3")) {
            return Arrays.asList("dm\u00b3");
        }
        if (word.toLowerCase().equals("m3")) {
            return Arrays.asList("m\u00b3");
        }
        if (word.toLowerCase().equals("km3")) {
            return Arrays.asList("km\u00b3");
        }
        ArrayList<String> newSuggestions = new ArrayList<String>();
        newSuggestions.addAll(this.findSuggestion(word, APOSTROF_INICI_VERBS, VERB_INDSUBJ, 2, "'", true));
        newSuggestions.addAll(this.findSuggestion(word, APOSTROF_INICI_VERBS_M, VERB_INDSUBJ_M, 2, "'", true));
        newSuggestions.addAll(this.findSuggestion(word, APOSTROF_INICI_VERBS_C, VERB_INDSUBJ_C, 2, "'", true));
        newSuggestions.addAll(this.findSuggestion(word, APOSTROF_INICI_VERBS_INF, VERB_INF, 2, "'", true));
        newSuggestions.addAll(this.findSuggestion(word, APOSTROF_INICI_NOM_SING, NOM_SING, 2, "'", true));
        newSuggestions.addAll(this.findSuggestion(word, APOSTROF_INICI_NOM_PLURAL, NOM_PLURAL, 2, "'", true));
        newSuggestions.addAll(this.findSuggestion(word, IMPERATIVE_HYPHEN, VERB_IMP, 1, "-", true));
        newSuggestions.addAll(this.findSuggestion(word, HYPHEN_JE, VERB_1S, 1, "-", true));
        newSuggestions.addAll(this.findSuggestion(word, HYPHEN_TU, VERB_2S, 1, "-", true));
        newSuggestions.addAll(this.findSuggestion(word, HYPHEN_ON, VERB_3S, 1, "-", true));
        newSuggestions.addAll(this.findSuggestion(word, HYPHEN_NOUS, VERB_1P, 1, "-", true));
        newSuggestions.addAll(this.findSuggestion(word, HYPHEN_VOUS, VERB_2P, 1, "-", true));
        newSuggestions.addAll(this.findSuggestion(word, HYPHEN_ILS, VERB_3P, 1, "-", true));
        if (!newSuggestions.isEmpty()) {
            return newSuggestions;
        }
        return Collections.emptyList();
    }

    private List<String> findSuggestion(String word, Pattern wordPattern, Pattern postagPattern, int suggestionPosition, String separator, boolean recursive) {
        ArrayList<String> newSuggestions = new ArrayList<String>();
        Matcher matcher = wordPattern.matcher(word);
        if (matcher.matches()) {
            List moreSugg;
            String newSuggestion = matcher.group(suggestionPosition);
            AnalyzedTokenReadings newatr = FrenchTagger.INSTANCE.tag(Arrays.asList(newSuggestion)).get(0);
            if (this.matchPostagRegexp(newatr, postagPattern)) {
                newSuggestions.add(matcher.group(1) + separator + matcher.group(2));
                return newSuggestions;
            }
            if (recursive && (moreSugg = this.speller1.getSuggestions(newSuggestion)).size() > 0) {
                for (int i = 0; i < moreSugg.size(); ++i) {
                    String newWord = suggestionPosition == 1 ? ((String)moreSugg.get(i)).toLowerCase() + matcher.group(2) : matcher.group(1) + (String)moreSugg.get(i);
                    List<String> newSugg = this.findSuggestion(newWord, wordPattern, postagPattern, suggestionPosition, separator, false);
                    if (!newSugg.isEmpty()) {
                        newSuggestions.addAll(newSugg);
                    }
                    if (i > 5) break;
                }
            }
        }
        if (!newSuggestions.isEmpty()) {
            return newSuggestions;
        }
        return Collections.emptyList();
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            return true;
        }
        return false;
    }
}

