/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class QuestionWhitespaceRule
extends Rule {
    private static final Pattern urlPattern = Pattern.compile("^(file|s?ftp|finger|git|gopher|hdl|https?|shttp|imap|mailto|mms|nntp|s?news(post|reply)?|prospero|rsync|rtspu|sips?|svn|svn\\+ssh|telnet|wais)$");
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().tokenRegex("[:;]").build(), new PatternTokenBuilder().csToken("-").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().tokenRegex("[\\(\\)D]").setIsWhiteSpaceBefore(false).build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[:;]").build(), new PatternTokenBuilder().tokenRegex("[\\(\\)D]").setIsWhiteSpaceBefore(false).build()), Arrays.asList(new PatternTokenBuilder().tokenRegex(".*\\d{1,2}").build(), new PatternTokenBuilder().token(":").build(), new PatternTokenBuilder().tokenRegex("\\d{1,2}").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[?!]").build(), new PatternTokenBuilder().tokenRegex("[?!]").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[a-z0-9]{2}").build(), new PatternTokenBuilder().token(":").build(), new PatternTokenBuilder().tokenRegex("[a-z0-9]{2}").build(), new PatternTokenBuilder().token(":").build(), new PatternTokenBuilder().tokenRegex("[a-z0-9]{2}").build()), Arrays.asList(new PatternTokenBuilder().token(";").build(), new PatternTokenBuilder().tokenRegex(".+").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().token(";").setIsWhiteSpaceBefore(false).build()), Arrays.asList(new PatternTokenBuilder().tokenRegex(".+").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().token(";").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().tokenRegex(".+").setIsWhiteSpaceBefore(false).build()));
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public QuestionWhitespaceRule(ResourceBundle messages, Language language) {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.antiPatterns = QuestionWhitespaceRule.cacheAntiPatterns((Language)language, ANTI_PATTERNS);
    }

    public String getId() {
        return "FRENCH_WHITESPACE";
    }

    public String getDescription() {
        return "Insertion des espaces fines ins\u00e9cables";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokens();
        String prevPrevToken = "";
        String prevToken = "";
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].isImmunized()) continue;
            String token = tokens[i].getToken();
            boolean isWhiteBefore = i > 0 ? tokens[i - 1].isWhitespace() : false;
            String msg = null;
            int fixFromPos = 0;
            int fixToPos = 0;
            String suggestionText = null;
            if (!isWhiteBefore) {
                if (token.equals("?") && !prevToken.equals("!")) {
                    msg = "Point d'interrogation est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                    suggestionText = prevToken + "\u202f?";
                    fixToPos = 1;
                } else if (token.equals("!") && !prevToken.equals("?")) {
                    msg = "Point d'exclamation est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                    suggestionText = prevToken + "\u202f!";
                    fixToPos = 1;
                } else if (token.equals(";")) {
                    msg = "Point-virgule est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                    suggestionText = prevToken + "\u202f;";
                    fixToPos = 1;
                } else if (token.equals(":")) {
                    Matcher matcherUrl = urlPattern.matcher(prevToken);
                    if (!matcherUrl.find()) {
                        msg = "Deux-points pr\u00e9c\u00e9d\u00e9s d'une espace ins\u00e9cable.";
                        suggestionText = prevToken + "\u00a0:";
                        fixToPos = 1;
                    }
                } else if (token.equals("\u00bb")) {
                    msg = "Le guillemet fermant est pr\u00e9c\u00e9d\u00e9 d'une espace ins\u00e9cable.";
                    if (prevPrevToken.equals("\u00ab")) {
                        suggestionText = "\u00ab\u00a0" + prevToken + "\u00a0\u00bb";
                        fixFromPos = -1;
                        fixToPos = 2;
                    } else {
                        suggestionText = prevToken + "\u00a0\u00bb";
                        fixToPos = 1;
                    }
                }
            }
            if (msg != null) {
                int fromPos = tokens[i - 1].getStartPos() + fixFromPos;
                int toPos = fromPos + fixToPos + tokens[i - 1].getToken().length();
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, msg, "Ins\u00e9rer un espace ins\u00e9cable");
                ruleMatch.setSuggestedReplacement(suggestionText);
                ruleMatches.add(ruleMatch);
            }
            prevPrevToken = prevToken;
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

