/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.language.Spanish;
import org.languagetool.rules.AbstractRepeatedWordsRule;
import org.languagetool.rules.SynonymsData;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.es.SpanishSynthesizer;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class SpanishRepeatedWordsRule
extends AbstractRepeatedWordsRule {
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns = SpanishRepeatedWordsRule.cacheAntiPatterns((Language)Spanish.getInstance(), ANTI_PATTERNS);
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.token((String)"tambi\u00e9n"), PatternRuleBuilderHelper.csRegex((String)".+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)".+"), PatternRuleBuilderHelper.token((String)"tambi\u00e9n")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[Aa]ntes|[Dd]espu\u00e9s"), PatternRuleBuilderHelper.csRegex((String)"de|del")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[Tt]ema|TEMA"), PatternRuleBuilderHelper.csRegex((String)"\\d+|[IXVC]+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[Aa]s\u00ed"), PatternRuleBuilderHelper.token((String)"que")));
    private static final Map<String, SynonymsData> wordsToCheck = SpanishRepeatedWordsRule.loadWords((String)"/es/synonyms.txt");

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public SpanishRepeatedWordsRule(ResourceBundle messages) {
        super(messages, (Language)Spanish.getInstance());
        super.setTags(Collections.singletonList(Tag.picky));
    }

    protected String getMessage() {
        return "Esta palabra ya ha aparecido en una de las frases inmediatamente anteriores. Puede usar un sin\u00f3nimo para hacer m\u00e1s interesante el texto, excepto si la repetici\u00f3n es intencionada.";
    }

    public String getDescription() {
        return "Sin\u00f3nimos para palabras repetidas.";
    }

    protected Map<String, SynonymsData> getWordsToCheck() {
        return wordsToCheck;
    }

    protected String getShortMessage() {
        return "Estilo: palabra repetida";
    }

    protected Synthesizer getSynthesizer() {
        return SpanishSynthesizer.INSTANCE;
    }

    protected String adjustPostag(String postag) {
        if (postag.contains("CN")) {
            return StringUtils.replaceOnce((String)postag, (String)"CN", (String)"..");
        }
        if (postag.contains("MS")) {
            return StringUtils.replaceOnce((String)postag, (String)"MS", (String)"[MC][SN]");
        }
        if (postag.contains("FS")) {
            return StringUtils.replaceOnce((String)postag, (String)"FS", (String)"[FC][SN]");
        }
        if (postag.contains("MP")) {
            return StringUtils.replaceOnce((String)postag, (String)"MP", (String)"[MC][PN]");
        }
        if (postag.contains("FP")) {
            return StringUtils.replaceOnce((String)postag, (String)"FP", (String)"[FC][PN]");
        }
        if (postag.contains("CS")) {
            return StringUtils.replaceOnce((String)postag, (String)"CS", (String)"[MC][SN]");
        }
        if (postag.contains("CP")) {
            return StringUtils.replaceOnce((String)postag, (String)"CP", (String)"[MC][PN]");
        }
        if (postag.contains("MN")) {
            return StringUtils.replaceOnce((String)postag, (String)"MN", (String)"[MC][SPN]");
        }
        if (postag.contains("FN")) {
            return StringUtils.replaceOnce((String)postag, (String)"FN", (String)"[FC][SPN]");
        }
        return postag;
    }

    protected boolean isException(AnalyzedTokenReadings[] tokens, int i, boolean sentStart, boolean isCapitalized, boolean isAllUppercase) {
        if (isAllUppercase || isCapitalized && !sentStart) {
            return true;
        }
        return tokens[i].hasPosTagStartingWith("NP") || tokens[i].hasPosTag("_english_ignore_");
    }
}

