/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.es;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class SpanishTagger
extends BaseTagger {
    public static final SpanishTagger INSTANCE = new SpanishTagger();
    private static final Pattern ADJ_PART_FS = Pattern.compile("VMP00SF|A[QO].[FC]S.");
    private static final Pattern VERB = Pattern.compile("V.+");
    private static final Pattern PREFIXES_FOR_VERBS = Pattern.compile("(auto)([^r]...+)", 66);
    private static final Pattern PREFIXES_FOR_VERBS2 = Pattern.compile("(autor)(r...+)", 66);
    private static final Pattern PREFIXES_FOR_ADJ = Pattern.compile("(.+)-(.+)", 66);
    private static final Pattern ADJ = Pattern.compile("AQ.+");
    private static final Pattern ADJ_MS = Pattern.compile("AQ.MS.|AQ.CS.|AQ.MN.");
    private static final Pattern NO_PREFIXES_FOR_ADJ = Pattern.compile("(anti|pre|ex|pro|afro|ultra|super|s\u00faper)", 66);
    private static final Pattern PREFIXES_FOR_ADJECTIVES = Pattern.compile("(super)(.*[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00ef\u00fc].+[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00ef\u00fc].*)", 66);
    private static final Pattern ADJ_VP = Pattern.compile("AQ.*|V.P.*");

    public SpanishTagger() {
        super("/es/es-ES.dict", new Locale("es"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        for (int i = 0; i < sentenceTokens.size(); ++i) {
            String word = sentenceTokens.get(i);
            String previousWord = "";
            String nextWord = "";
            if (i > 0) {
                previousWord = sentenceTokens.get(i - 1);
            }
            if (i < sentenceTokens.size() - 1) {
                nextWord = sentenceTokens.get(i + 1);
            }
            boolean containsTypographicApostrophe = false;
            if ((word.length() > 1 || previousWord.equalsIgnoreCase("l") || previousWord.equalsIgnoreCase("d") || nextWord.equalsIgnoreCase("s")) && word.contains("\u2019")) {
                containsTypographicApostrophe = true;
                word = word.replace("\u2019", "'");
            }
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase((String)word);
            boolean isAllUpper = StringTools.isAllUppercase((String)word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
            this.addTokens(taggerTokens, l);
            if (!isLowercase && !isMixedCase) {
                List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
                this.addTokens(lowerTaggerTokens, l);
            }
            if (isAllUpper) {
                String firstUpper = StringTools.uppercaseFirstChar((String)lowerWord);
                List firstupperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(firstUpper));
                this.addTokens(firstupperTaggerTokens, l);
            }
            if (l.isEmpty() && !isMixedCase) {
                this.addTokens(this.additionalTags(word, (IStemmer)dictLookup), l);
            }
            if (l.isEmpty() && StringTools.isEmoji((String)word)) {
                l.add(new AnalyzedToken(word, "_emoji_", "_emoji_"));
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            if (containsTypographicApostrophe) {
                atr.setTypographicApostrophe();
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(String word, IStemmer stemmer) {
        String possibleAdjPrefix;
        Matcher matcher2;
        String posTag;
        List taggerTokens;
        String possibleVerb;
        Matcher matcher;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        String lowerWord = word.toLowerCase(this.locale);
        if (lowerWord.endsWith("mente")) {
            String possibleAdj = lowerWord.replaceAll("^(.+)mente$", "$1");
            List taggerTokens2 = this.asAnalyzedTokenList(possibleAdj, dictLookup.lookup((CharSequence)possibleAdj));
            for (Object taggerToken : taggerTokens2) {
                Matcher m;
                String posTag2 = taggerToken.getPOSTag();
                if (posTag2 == null || !(m = ADJ_PART_FS.matcher(posTag2)).matches()) continue;
                additionalTaggedTokens.add(new AnalyzedToken(word, "RG", lowerWord));
                return additionalTaggedTokens;
            }
        }
        if ((matcher = PREFIXES_FOR_VERBS.matcher(word)).matches()) {
            possibleVerb = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenList(possibleVerb, dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                Matcher m;
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches()) continue;
                String lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            return additionalTaggedTokens;
        }
        matcher = PREFIXES_FOR_VERBS2.matcher(word);
        if (matcher.matches()) {
            possibleVerb = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenList(possibleVerb, dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                Matcher m;
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches()) continue;
                String lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            return additionalTaggedTokens;
        }
        matcher = PREFIXES_FOR_ADJECTIVES.matcher(word);
        if (matcher.matches()) {
            possibleVerb = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenList(possibleVerb, dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                Matcher m;
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = ADJ_VP.matcher(posTag)).matches()) continue;
                String lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            return additionalTaggedTokens;
        }
        matcher = PREFIXES_FOR_ADJ.matcher(word);
        if (matcher.matches() && !(matcher2 = NO_PREFIXES_FOR_ADJ.matcher(possibleAdjPrefix = matcher.group(1).toLowerCase())).matches()) {
            Matcher m;
            String posTag3;
            String possibleAdj = matcher.group(2).toLowerCase();
            boolean prefixMatches = false;
            boolean adjMatches = false;
            String newPostag = "";
            Object newLemma = "";
            List taggerTokens3 = this.asAnalyzedTokenList(possibleAdjPrefix, dictLookup.lookup((CharSequence)possibleAdjPrefix));
            for (AnalyzedToken taggerToken : taggerTokens3) {
                posTag3 = taggerToken.getPOSTag();
                if (posTag3 == null || !(m = ADJ_MS.matcher(posTag3)).matches()) continue;
                prefixMatches = true;
                break;
            }
            taggerTokens3 = this.asAnalyzedTokenList(possibleAdj, dictLookup.lookup((CharSequence)possibleAdj));
            for (AnalyzedToken taggerToken : taggerTokens3) {
                posTag3 = taggerToken.getPOSTag();
                if (posTag3 == null || !(m = ADJ.matcher(posTag3)).matches()) continue;
                adjMatches = true;
                newPostag = posTag3;
                newLemma = possibleAdjPrefix + "-" + taggerToken.getLemma();
                break;
            }
            if (adjMatches && prefixMatches) {
                additionalTaggedTokens.add(new AnalyzedToken(word, newPostag, (String)newLemma));
                return additionalTaggedTokens;
            }
        }
        return null;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

