/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.es;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.tagging.es.SpanishTagger;
import org.languagetool.tokenizers.WordTokenizer;

public class SpanishWordTokenizer
extends WordTokenizer {
    private static final Pattern DECIMAL_POINT = Pattern.compile("([\\d])\\.([\\d])", 66);
    private static final Pattern DECIMAL_COMMA = Pattern.compile("([\\d]),([\\d])", 66);
    private static final Pattern ORDINAL_POINT = Pattern.compile("\\b([\\d]+)\\.(\u00ba|\u00aa|o|a|er|os|as)\\b", 66);
    private final String ES_TOKENIZING_CHARACTERS = this.getTokenizingCharacters() + "\u2212";

    public List<String> tokenize(String text) {
        ArrayList<String> l = new ArrayList<String>();
        String auxText = text;
        Matcher matcher = DECIMAL_POINT.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001ES_DECIMAL_POINT\u0001\u0001$2");
        matcher = DECIMAL_COMMA.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001ES_DECIMAL_COMMA\u0001\u0001$2");
        matcher = ORDINAL_POINT.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001ES_ORDINAL_POINT\u0001\u0001$2");
        StringTokenizer st = new StringTokenizer(auxText, this.ES_TOKENIZING_CHARACTERS, true);
        while (st.hasMoreElements()) {
            String s = st.nextToken().replace("\u0001\u0001ES_DECIMAL_POINT\u0001\u0001", ".").replace("\u0001\u0001ES_DECIMAL_COMMA\u0001\u0001", ",").replace("\u0001\u0001ES_ORDINAL_POINT\u0001\u0001", ".");
            l.addAll(this.wordsToAdd(s));
        }
        return this.joinEMailsAndUrls(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> wordsToAdd(String s) {
        ArrayList<String> l = new ArrayList<String>();
        SpanishWordTokenizer spanishWordTokenizer = this;
        synchronized (spanishWordTokenizer) {
            if (!s.isEmpty()) {
                if (!s.contains("-")) {
                    l.add(s);
                } else if (SpanishTagger.INSTANCE.tag(Arrays.asList(s.replaceAll("\u00ad", "").replace("\u2019", "'"))).get(0).isTagged()) {
                    l.add(s);
                } else if (s.equalsIgnoreCase("mers-cov") || s.equalsIgnoreCase("mcgraw-hill") || s.equalsIgnoreCase("sars-cov-2") || s.equalsIgnoreCase("sars-cov") || s.equalsIgnoreCase("ph-metre") || s.equalsIgnoreCase("ph-metres")) {
                    l.add(s);
                } else {
                    StringTokenizer st2 = new StringTokenizer(s, "-", true);
                    while (st2.hasMoreElements()) {
                        l.add(st2.nextToken());
                    }
                }
            }
            return l;
        }
    }
}

